/***************************************************************************
                          digikam.h  -  description
                             -------------------
    begin                : Thu Dec 20 12:40:20 CST 2001
    copyright            : (C) 2001 by Renchi Raju
    email                : renchi@green.tam.uiuc.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DIGIKAM_H
#define DIGIKAM_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <kstatusbar.h>
#include <kprogress.h>

#include <qmap.h>
#include <qlabel.h>

#include "digikam_mainwindow.h"
#include "gphoto_interface.h"
#include "camera_folder.h"

/** Digikam is the base class of the project */
class Digikam : public Digikam_MainWindow
{
  Q_OBJECT 

  public:

    Digikam(QWidget* parent=0, const char *name=0);

    ~Digikam();


  protected slots:

      void slot_connect();
      void slot_setup();
      void slot_downloadImages();
      void slot_deleteImages();
      void slot_folderViewClicked(QListViewItem *);
      void slot_setSelection(int);
      void slot_browse(); 
      void slot_close();
      void slot_setStatusMsg(const QString&);
      void slot_about();
      
      //void slot_help(); 



 private:

    void initGlobals();
    void initView();
    int  initCamera();
    int getFolderNames(Camera_Folder* camFolder);
    int getIcons();
    void setStatusMsg(const QString &);
    void setAbilitiesButtons();

    Gphoto_Interface *gpInterface;
    KStatusBar *statusBar;
    KProgress  *progressBar;

    QString my_cameraFolder; 
    QLabel* statusLabel;


};

#endif
