/***************************************************************************
                          photo_iconview.h  -  description
                             -------------------
    begin                : Sun Jan 13 2002
    copyright            : (C) 2002 by Renchi Raju
    email                : renchi@green.tam.uiuc.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PHOTO_ICONVIEW_H
#define PHOTO_ICONVIEW_H

#include <qguardedptr.h>
#include <qiconview.h>

#include <kfileview.h>

#include "thumbnailsize.h"

class QString;
class QFileInfo;
class ThumbnailLoadJob;

class Photo_IconView : public QIconView, public KFileView {
Q_OBJECT
 public:

  Photo_IconView(QWidget* parent=0, const char* name=0);
  ~Photo_IconView();
  QWidget* widget() { return this; }

  void clearView();
  void clearSelection() { QIconView::clearSelection(); }
  void insertItem(KFileViewItem* item);
  void removeItem(const KFileViewItem* item);
  void ensureItemVisible(const KFileViewItem* item);
  void setSelected(const KFileViewItem* item,bool enable);
  bool isSelected(const KFileViewItem* item) const;

  void setThumbSize(ThumbnailSize size);
  void startGenThumbnail();
  void stopGenThumbnail();

 protected:
  
  void startDrag();

 private:

  ThumbnailSize thumbnailSize;
  QGuardedPtr<ThumbnailLoadJob> thumbnailGenerator;

 signals:

  void startedGenThumbnail(int);
  void stoppedGenThumbnail();
  void generatedOneThumbnail();


 public slots:

   void slot_setThumbnail(const KFileViewItem*,const QPixmap&);
   void slot_displayImage(QIconViewItem* item);
   void slot_popupMenu(QIconViewItem* item, const QPoint& pos);
   void slot_itemRenamed(QIconViewItem* item,const QString& newName);
};


#endif
