/***************************************************************************
                          digikam.h  -  description
                             -------------------
    begin                : Wed Jan  9 18:01:17 CST 2002
    copyright            : (C) 2002 by Renchi Raju
    email                : renchi@green.tam.uiuc.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DIGIKAM_H
#define DIGIKAM_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <qwidget.h>
#include <kmainwindow.h>
#include <kfileitem.h>

class KToolBar;
class KConfig;
class KAction;
class KRadioAction;
class KToolBarPopupAction;

class QString;
class QListViewItem;
class QIconViewItem;
class QTimer;

class Digikam_View;
class Gphoto_Interface;
class Camera_Folder;
class Camera_IconViewItem;
class Image_Lister;


class Digikam : public KMainWindow
{
  Q_OBJECT 

 public:

  Digikam();

  ~Digikam();

 protected slots:

  void slot_showHideToolBars(QWidget* name);
  void slot_startedGenThumbNails();
  void slot_stoppedGenThumbNails();

  void slot_setCamStatusMsg(const QString &msg);
  void slot_setCamProgressBarValue(int value);

 private:
 
  void initView();
  void initGlobals();
  void initToolBars();
  void setAbilitiesButtons();
  void setCamStatusMsg(const QString &msg);
  void restoreCamButtons();
  void readConfig();
  void readOptions();
  void saveOptions();
  bool queryExit();
  int initCamera();
  int getFolderNames(Camera_Folder* camFolder);
  int getIcons();

  void insertIconGlobal(Camera_IconViewItem* item);
  void syncIconGlobal(Camera_IconViewItem* item);
  void removeIconGlobal(Camera_IconViewItem* item);


  Digikam_View *view;
  KToolBar* toolBarCameraBrowser;
  KToolBar* toolBarPhotoBrowser;

  Gphoto_Interface *gpInterface; 
  QString my_cameraFolder;
  bool stopDownloading;

  KAction* camConnectAction;
  KToolBarPopupAction* camDownloadAction;
  KAction* camUploadAction;
  KAction* camDeleteAction;
  KAction* camCancelAction;
  KToolBarPopupAction* camSelectAction;
  KAction* camMkFolderAction;
  KAction* camSetupAction;
  KAction* camCameraInfoAction;
  KAction* appQuitAction;
  
  // Configuration variables
    
  KConfig *config;
  QString DEFAULT_DOWNLOAD_DIR;
  bool NO_THUMBNAIL_STARTUP;
  bool CONNECT_STARTUP;
  bool  SHOWALLIMAGES_STARTUP;


  // Photo Browser Variables
  Image_Lister *imageLister;

  KRadioAction* photoSmallThumbs;
  KRadioAction* photoMedThumbs;
  KRadioAction* photoLargeThumbs;
  KAction* photoHomeAction;
  KAction* photoCancelAction;

 private slots:
  
  void slot_connect();
  void slot_camFolderViewClicked(QListViewItem *item);
  void slot_getThumbNails(bool checked);
  void slot_downloadImages();
  void slot_downloadAllImages();
  void slot_deleteImages();
  void slot_stopDownloadImages();
  void slot_camMkFolder();
  void slot_setCamSelection(int selectMode) ;
  void slot_camDirBrowse();
  void slot_close();
  void slot_cameraInfo();
  void slot_setup();

  void slot_photoFolderClicked(QListViewItem *item);
  void slot_newImageItems(const KFileItemList& fileItemList);
  void slot_deleteImageItem(KFileItem* item);
  void slot_photoViewClear();
  void slot_imageListerCompleted();
  void slot_imageListerCanceled();
  void slot_photoGoHome();
  void slot_setPhotoThumbSize();
  void slot_stopGenThumbNails();

};

#endif
