#ifndef SETUP_H
#define SETUP_H

#include <qstring.h>
#include <ksimpleconfig.h>

#include "setup_base.h"
#include "gphoto_interface.h"

class Setup: public Setup_Base {

  Q_OBJECT
  
public:

  Setup(QWidget *_parent=0, const char *name=0);
  ~Setup();

private:

  void getCameraListings();
  void getPortListings();
  void loadCameraSettings();
  void saveCameraSettings();
  void loadGeneralSettings();
  void saveGeneralSettings();


  KSimpleConfig *config;
  
  QStringList supportedSerialPorts;
  QString my_cameraModel;
  QString my_cameraPort;

  Gphoto_Interface *gpInterface;


protected slots:

  void slot_ok();
  void slot_apply();
  void slot_cancel();
  void slot_autoDetect();
  void slot_setModel(QListViewItem *);
  void slot_setPort(int portType);
  void slot_setPortPathLabel(int portType);
  void slot_browse();
	
};


#endif
