#ifndef CUSTOMEVENTS_H
#define CUSTOMEVENTS_H

#include <qevent.h>
#include <qpixmap.h>
#include <qstring.h>

#include "thumbnailmt.h"


enum CustomEventTypes {
    EventThumbnailT = QCustomEvent::User,
    EventBusyT
};

class EventThumbnail : public QCustomEvent {

public:

    EventThumbnail(const QString& parentFolder,
                   const QString& fileName,
                   const ThumbnailMT& thumbnail)
        : QCustomEvent(EventThumbnailT),
          mParentFolder(parentFolder.latin1()),
          mFileName(fileName.latin1()),
          mThumbnail(thumbnail)
        {}

    void getParentFolder(QString& folder)
        { folder = QString(mParentFolder.latin1()); }
    void getFileName(QString& fileName)
        { fileName = QString(mFileName.latin1()); }
    void getThumbNail(QPixmap& pixmap)
        { mThumbnail.fillPixmap(pixmap); }

private:

    QString mParentFolder;
    QString mFileName;
    ThumbnailMT mThumbnail;

};


class EventBusy : public QCustomEvent {

public:

  EventBusy(bool _busy):
    QCustomEvent(EventBusyT),
    m_busy(_busy)
  {}

  bool busy() { return m_busy;}

private:

  bool m_busy;

};

#endif
