/* This file is part of KDevelop
    Copyright 2010 Aleix Pol Gonzalez <aleixpol@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#include "sessionsmodel.h"
#include <shell/core.h>

SessionsModel::SessionsModel(QObject* parent)
    : QAbstractListModel(parent)
    , m_sessions(KDevelop::SessionController::availableSessionInfo())
{
    QHash< int, QByteArray > roles = roleNames();
    roles.insert(Uuid, "uuid");
    roles.insert(Projects, "projects");
    roles.insert(ProjectNames, "projectNames");
    setRoleNames(roles);
}

QVariant SessionsModel::data(const QModelIndex& index, int role) const
{
    if(!index.isValid() || index.row()>m_sessions.count()) {
        return QVariant();
    }
    
    switch(role) {
        case Qt::DisplayRole:
            return m_sessions[index.row()].name;
        case Qt::ToolTip:
            return m_sessions[index.row()].description;
        case Uuid:
            return m_sessions[index.row()].uuid.toString();
        case Projects:
            return m_sessions[index.row()].projects;
        case ProjectNames: {
            QVariantList ret;
            foreach(const KUrl& project, m_sessions[index.row()].projects) {
                ret += project.fileName();
            }
            return ret;
        }
    }
    return QVariant();
}

int SessionsModel::rowCount(const QModelIndex& parent) const
{
    return parent.isValid() ? 0 : m_sessions.size();
}

void SessionsModel::loadSession(const QString& nameOrId) const
{
    KDevelop::Core::self()->sessionController()->loadSession(nameOrId);
}
