/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  query.h  -  description
  begin:     Mon Jan 28 2002
  copyright: (C) 2002 by Dario Abatianni
  email:     eisfuchs@tigress.com

  $Id: query.h,v 1.8 2002/12/11 16:25:51 eisfuchs Exp $
*/

#include <qobject.h>
#include <qvbox.h>
#include <qiconset.h>
#include <qcheckbox.h>

#ifndef QUERY_H
#define QUERY_H

#include "chatwindow.h"
#include "server.h"
#include "ircinput.h"

/*
  @author Dario Abatianni
*/

/* TODO: Idle counter to close query after XXX minutes of inactivity */
/* TODO: Use /USERHOST to check if queries are still valid */
class Query : public ChatWindow
{
  Q_OBJECT

  public:
    Query(QWidget* parent);
    ~Query();

    void setName(const QString& newName);
    void setHostmask(const QString& newHostmask);
    void setServer(Server* setServer);

  signals:
    void newText(QWidget* query);
    void closed(Query* query);

  protected slots:
    void queryTextEntered();
    void newTextInView();
    void close();

  protected:
    int spacing();
    int margin();

    QString queryName;
    QString hostmask;
    QString buffer;

    QLineEdit* queryHostmask;
    IRCInput* queryInput;
    QCheckBox* logCheckBox;
};

#endif
