/*
  Copyright (c) 2012-2020 Laurent Montel <montel@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef SELECTTHUNDERBIRDFILTERFILESWIDGET_H
#define SELECTTHUNDERBIRDFILTERFILESWIDGET_H

#include <QWidget>
class QUrl;
class QAbstractButton;

namespace Ui {
class SelectThunderbirdFilterFilesWidget;
}
namespace MailCommon {
class SelectThunderbirdFilterFilesWidget : public QWidget
{
    Q_OBJECT

public:
    explicit SelectThunderbirdFilterFilesWidget(const QString &defaultSettingPath, QWidget *parent = nullptr);
    ~SelectThunderbirdFilterFilesWidget();
    Q_REQUIRED_RESULT QStringList selectedFiles() const;

    void setStartDir(const QUrl &);

Q_SIGNALS:
    void enableOkButton(bool);

private:
    void slotButtonClicked(QAbstractButton *button);
    void slotProfileChanged(int);

    void slotUrlChanged(const QString &path);
    void slotItemSelectionChanged();
    Ui::SelectThunderbirdFilterFilesWidget *const ui;
};
}
#endif // SELECTTHUNDERBIRDFILTERFILESWIDGET_H
