/***************************************************************************
 *   Copyright (C) 2010 by SIDDHARTH SHARMA siddharth.kde@gmail.com        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
* This file is Plasma Applet for Report Skroogoid
*
* @author Siddharth SHARMA
*/

#include "reportskroogoid.h"
#include <QGraphicsLinearLayout>

ReportSkroogoid::ReportSkroogoid(QObject* iParent, const QVariantList& args)  :
    Plasma::Applet(iParent, args), m_widget(NULL), m_layout(NULL), pw(NULL), view(NULL)

{
    this->setMaximumSize(450, 350);
}
void ReportSkroogoid::init()
{
    if (pw == NULL) {
        pw = new QGraphicsProxyWidget();
        view = new  SKGTableWithGraph();
        view->isGraphTypeSelectorVisible();
        view->setAttribute(Qt::WA_TranslucentBackground, true);

        pw->setWidget(view);
        QGraphicsLinearLayout* linearLayout = new QGraphicsLinearLayout(this);
        linearLayout->addItem(pw);
    }
}

ReportSkroogoid::~ReportSkroogoid()
{

}

#include "reportskroogoid.moc"
