/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is plugin for tip of day.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtipofdayboardwidget.h"
#include "skgtraces.h"
#include "skgservices.h"
#include "skgmainpanel.h"

#include <KTipDatabase>

SKGTipOfDayBoardWidget::SKGTipOfDayBoardWidget(SKGDocument* iDocument)
    : SKGBoardWidget(iDocument, i18nc("Dashboard widget title", "Tip of the day"))
{
    SKGTRACEIN(10, "SKGTipOfDayBoardWidget::SKGTipOfDayBoardWidget");

    QFrame* f = new QFrame();
    ui.setupUi(f);
    setMainWidget(f);
    ui.kIcon->setIcon(KIcon("ktip"));

    onModified();

    connect(ui.kIcon, SIGNAL(clicked(bool)), this, SLOT(onModified()));

    //Refresh
    connect((const QObject*) getDocument(), SIGNAL(transactionSuccessfullyEnded(int)), this, SLOT(onModified()), Qt::QueuedConnection);

}

SKGTipOfDayBoardWidget::~SKGTipOfDayBoardWidget()
{
    SKGTRACEIN(10, "SKGTipOfDayBoardWidget::~SKGTipOfDayBoardWidget");
}

void SKGTipOfDayBoardWidget::onModified()
{
    KTipDatabase db(SKGMainPanel::getMainPanel()->getTipOfDayFileName());
    db.nextTip();
    ui.kText->setText(SKGServices::htmlToString(db.tip()));
}

#include "skgtipofdayboardwidget.moc"
