/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is Skrooge plugin for bank management.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgreportboardwidget.h"

#include <qinputdialog.h>

#include "skgdocumentbank.h"
#include "skgtraces.h"
#include "skgmainpanel.h"
#include "skgreportpluginwidget.h"

SKGReportBoardWidget::SKGReportBoardWidget(SKGDocumentBank* iDocument)
    : SKGBoardWidget(iDocument, i18nc("Dashboard widget title", "Report"), true)
{
    SKGTRACEINFUNC(10);

    // This must be done at the beginning
    this->setMinimumSize(200, 200);

    // Create menu
    setContextMenuPolicy(Qt::ActionsContextMenu);

    QStringList overlayopen;
    overlayopen.push_back("quickopen");
    QAction* open = new QAction(SKGServices::fromTheme("view-statistics", overlayopen), i18nc("Verb", "Open report..."), this);
    connect(open, &QAction::triggered, this, &SKGReportBoardWidget::onOpen);
    addAction(open);

    m_menuRename = new QAction(QIcon::fromTheme("edit-rename"), i18nc("Verb, change the name of an item", "Rename"), this);
    connect(m_menuRename, &QAction::triggered, this, &SKGReportBoardWidget::onRenameTitle);
    addAction(m_menuRename);

    m_graph = new SKGReportPluginWidget(iDocument, true);
    setMainWidget(m_graph);

    // Refresh
    connect(getDocument(), &SKGDocument::tableModified, this, &SKGReportBoardWidget::dataModified, Qt::QueuedConnection);
}

SKGReportBoardWidget::~SKGReportBoardWidget()
{
    SKGTRACEINFUNC(10);
    m_graph = NULL;
    m_menuRename = NULL;
}

QString SKGReportBoardWidget::getState()
{
    QDomDocument doc("SKGML");
    QDomElement root = doc.createElement("parameters");
    doc.appendChild(root);

    root.setAttribute("title", getMainTitle());
    if (m_graph) {
        root.setAttribute("graph", m_graph->getState());
    }
    return doc.toString();

    // return ( graph ? graph->getState() : "" );
}

void SKGReportBoardWidget::setState(const QString& iState)
{
    QDomDocument doc("SKGML");
    if (doc.setContent(iState)) {
        QDomElement root = doc.documentElement();

        QString title = root.attribute("title");
        if (!title.isEmpty()) {
            setMainTitle(title);
        }


        QString graphS = root.attribute("graph");
        if (m_graph) {
            if (graphS.isEmpty()) {
                m_graph->setState(iState);
            } else {
                m_graph->setState(graphS);
            }
        }
    }

    dataModified("", 0);
}

void SKGReportBoardWidget::onRenameTitle()
{
    bool ok = false;
    QString newTitle = QInputDialog::getText(SKGMainPanel::getMainPanel(), i18nc("Question", "Title"),
                       i18nc("Question", "New title:"), QLineEdit::Normal, getMainTitle(), &ok);
    if (ok) {
        setMainTitle(newTitle);
    }
}

void SKGReportBoardWidget::dataModified(const QString& iTableName, int iIdTransaction)
{
    SKGTRACEINFUNC(10);
    Q_UNUSED(iIdTransaction);
    if (iTableName == "operation" || iTableName.isEmpty()) {
        bool exist = false;
        getDocument()->existObjects("account", "", exist);
        if (parentWidget()) {
            parentWidget()->setVisible(exist);
        }
    }
}

void SKGReportBoardWidget::onOpen()
{
    QDomDocument doc("SKGML");
    QString graphS;
    if (doc.setContent(getState())) {
        QDomElement root = doc.documentElement();
        graphS = root.attribute("graph");

        QDomDocument doc2("SKGML");
        if (doc2.setContent(graphS)) {
            QDomElement root2 = doc2.documentElement();

            QString currentPage = root2.attribute("currentPage");
            if (SKGServices::stringToInt(currentPage) < -1) {
                root2.setAttribute("currentPage", "-1");
                graphS = doc2.toString();
            }
        }
    }
    SKGMainPanel::getMainPanel()->openPage(SKGMainPanel::getMainPanel()->getPluginByName("Skrooge report plugin"), -1, graphS);
}


