/***************************************************************************
 *   Copyright (C) 2011 by Francesco Nwokeka <francesco.nwokeka@gmail.com> *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA            *
 ***************************************************************************/

import Qt 4.7
import org.kde.plasma.core 0.1 as PlasmaCore

Item {
    id: panel;

    // these are loaded from config file
    property string globalNickFromConfig;
    property string globalStatusMessageFromConfig;
    property string globalAvatarFromConfig;
    property int globalPresenceIdFromConfig;
    property string globalPresenceTypeFromConfig;
    property string globalPresenceTextFromConfig;

    // global signals emitted from LeftPanel to main->RightPanel
    signal setGlobalStatusMessageSignal(variant globalStatus);
    signal setGlobalNickSignal(variant globalNick);
    signal setGlobalAvatarSignal(variant globalAvatar);
    signal setGlobalPresenceSignal(variant globalPresenceId, variant globalPresenceIconName);

    Component.onCompleted: {
        // load global config
        plasmoid.aciveConfig = "presenceapplet";
        globalNickFromConfig = plasmoid.readConfig("Nick");
        globalStatusMessageFromConfig = plasmoid.readConfig("PersonalStatus");
        globalAvatarFromConfig = plasmoid.readConfig("Avatar");
        globalPresenceIdFromConfig = plasmoid.readConfig("PresenceId");
        globalPresenceTypeFromConfig = plasmoid.readConfig("PresenceType");
        globalPresenceTextFromConfig = plasmoid.readConfig("PresenceText");
    }

    Avatar {
        id: globalAvatar;
        avatarPath: globalAvatarFromConfig;
        presenceId: globalPresenceIdFromConfig;

        anchors {
            top: parent.top;
            left: parent.left;
            margins: 5;
        }

        onAvatarChanged: {
            setGlobalAvatar(newAvatarSource);
        }
    }

    EditableText {
        id: globalNick;
        height: 30;
        boldText: true;
        editableText: globalNickFromConfig;

        anchors {
            top: parent.top;
            left: globalAvatar.right;
            right: parent.right;
            margins: 5;
        }

        onTextChanged: {
            setGlobalNick(newText);
        }
    }

    PresenceChooser {
        id: globalPresenceChooser;
        flipEnabled: true;
        presenceIconType: globalPresenceTypeFromConfig;
        presenceText: globalPresenceTextFromConfig;

        anchors {
            top: globalNick.bottom;
            left: globalAvatar.right;
            right: parent.right;
            margins: 5;
        }

        onPresenceChanged: {
            setGlobalPresence(presenceId, presenceIconName, presenceText);
        }
    }

    EditableText {
        id: globalStatusMessage;
        height: 20;
        width: 100;
        italicText: true;
        editableText: globalStatusMessageFromConfig;

        anchors {
            top: globalAvatar.bottom;
            left: parent.left;
            right: parent.right;
            topMargin: 10;
        }

        onTextChanged: {
            setGlobalStatusMessage(newText);
        }
    }

    LauncherPanel {
        id: globalLauncherPanel;
        height: 80;

        anchors {
            left: parent.left;
            right: parent.right;
            bottom: parent.bottom;
        }
    }

    // to verify if contactlist is installed
    PlasmaCore.DataSource {
        id: telepathyContactListSource;
        engine: "apps";
        interval: 0;

        onSourceAdded: {
            connectSource(source);
        }
        Component.onCompleted: {
            connectedSources = sources;
        }
    }

    // determine if telepathy-contactlist is installed on system
    // this determines the visibility of the launcher for the contactlist
    PlasmaCore.DataModel {
        dataSource: telepathyContactListSource;

        Component.onCompleted: {
            var found = false;

            // check if contactlist is installed
            // available from version >= 4
            if (plasmoid.applicationExists) {
                found = plasmoid.applicationExists("kde4-telepathy-kde-contactlist.desktop");
            } else {
                // for version < 4
                for(var i = 0; i < telepathyContactListSource.sources.length && !found; ++i) {
                    var sourceName = telepathyContactListSource.sources[i];
                    if (sourceName == "kde4-telepathy-kde-contactlist.desktop") {
                        found = true;
                    }
                }
            }
            globalLauncherPanel.contactlistInstalled = found;
        }
    }

    function setGlobalAvatar(newAvatarSource)
    {
        // get new avatar from the component and set it + save to config
        globalAvatarFromConfig = newAvatarSource;

        // show new avatar
        globalAvatar.setAvatar(newAvatarSource);

        // save to config
        plasmoid.writeConfig("Avatar", newAvatarSource);

        // send signal to right panel
        setGlobalAvatarSignal(newAvatarSource);
    }

    function setGlobalNick(newNick)
    {
        globalNickFromConfig = newNick;
        plasmoid.writeConfig("Nick", newNick);

        // send signal to right panel
        setGlobalNickSignal(newNick);
    }

    function setGlobalStatusMessage(newText)
    {
        globalStatusMessageFromConfig = newText;
        plasmoid.writeConfig("PersonalStatus", newText);

        // send signal to right panel
        setGlobalStatusMessageSignal(newText);
    }

    function setGlobalPresence(presenceId, presenceIconName, presenceText)
    {
        globalPresenceIdFromConfig = presenceId;
        globalPresenceTypeFromConfig = presenceIconName;
        globalPresenceTextFromConfig = presenceText;

        // show new presence on the front
        globalPresenceChooser.setFrontPresence(presenceIconName, presenceText);

        globalAvatar.setPresenceId(presenceId);

        // send signal to right panel
        setGlobalPresenceSignal(presenceId, presenceIconName);
    }
}
