#ifndef _KCOLORBUTTON_H_
#define _KCOLORBUTTON_H_

#include <Python.h>
#include <kcolorbtn.h>
#include <qpushbt.h>
#include <qcolor.h>
#include "Baseobject.h"


extern "C" void SWIG_MakePtr(char *, void *, char *);


class _ColorButton : public KColorButton, public BaseObject
{
  Q_OBJECT	

  public:
    _ColorButton(const QColor &c, QWidget *parent=0, const char *name=0) : KColorButton(c,parent,name), BaseObject() {
      connect(this, SIGNAL(pressed()), this, SLOT(sigPressed()));
      connect(this, SIGNAL(released()), this, SLOT(sigReleased()));
      connect(this, SIGNAL(clicked()), this, SLOT(sigClicked()));
      connect(this, SIGNAL(toggled(bool)), this, SLOT(sigToggled(bool)));
      connect(this, SIGNAL(changed(const QColor&)), this, SLOT(sigChanged(const QColor&)));
    };
    ~_ColorButton() {};
    
protected slots:

    void sigPressed() {
      _emit("pressed", 0);
    };
    
    void sigReleased() {
      _emit("released", 0);
    };
    
    void sigClicked() {
      _emit("clicked", 0);
    };
    
    void sigToggled(bool on) {
       PyObject *arg = Py_BuildValue("(i)",on);
       _emit("toggled", arg);  
       Py_DECREF(arg);
    };

    void sigChanged(const QColor &newColor ){
       char temp[128];
       SWIG_MakePtr(temp, (char *) &newColor, "_Color_p");
       PyObject *arg = Py_BuildValue("s",temp);
       _emit("changed", arg);  
       Py_DECREF(arg);
    };
    
};

#endif
