%module KEdit


%{
#include "KEdit.h"
#include "Object.h"
#include "Multilineedit.h"
%}


%include Types.i
%import Multilineedit.i
%import KApplication.i


class _Edit : public MultiLineEdit
{
public:
    _Edit (_Application *a,QWidget *parent=NULL, const char *name=NULL, 
	   const char *filename=NULL);
    ~_Edit();

    enum { NONE, 
	   FORWARD, 
	   BACKWARD };
    enum { KEDIT_OK 		= 0, 
	   KEDIT_OS_ERROR 	= 1, 
	   KEDIT_USER_CANCEL 	= 2 ,
	   KEDIT_RETRY 		= 3,
	   KEDIT_NOPERMISSIONS 	= 4};
    enum { OPEN_READWRITE 	= 1, 
	   OPEN_READONLY 	= 2, 
	   OPEN_INSERT 		= 4 };
    
    int  	newFile();
    int 	doSave();
%name(doSaveAs)    int 	doSave( const char *filename );
    int 	saveAs();
    int 	openFile( int mode );
    int 	insertFile();
    int 	loadFile( QString filename , int mode );
    QString 	getName();
    void 	setName( const char *_name );
    QString 	markedText();
    void 	selectFont();
    void 	Search();
    int 	repeatSearch();
    void 	Replace();
    void 	doGotoLine();
    bool 	isModified();
    void 	toggleModified( bool );
    void 	setAutoIndentMode( bool );
    bool        AutoIndentMode(){ return autoIndentMode; };
    void 	installRBPopup( QPopupMenu* );
    int 	currentLine();
    int 	currentColumn();
    bool 	WordWrap();
    void 	setWordWrap(bool );
    bool 	FillColumnMode();
    void  	setFillColumnMode(int line, bool set);
    void       saveBackupCopy(bool copy);
    void       setFileName(char* name);

/*
signals:
    void 	fileChanged();
    void 	CursorPositionChanged();
    void 	saving();
    void 	loading();
    void 	toggle_overwrite_signal();
*/

    void setModified();
    void computePosition();
};
