#include "Baseobject.h"


BaseObject::BaseObject()
{
  connections.setAutoDelete(TRUE);
}


void BaseObject::_connect(const char *signal, PyObject *slot)
{
  // Python memory management
  Py_INCREF(slot);

  Connection *c = new Connection;
  c->signal = strdup(signal);
  c->slot = slot;
  connections.append(c);
}

void BaseObject::_disconnect(const char *signal, PyObject *slot)
{
  Connection *c;
  for(c = connections.first(); c!=0; c = connections.next())
    if(strcmp(c->signal, signal) == 0 || c->slot == slot)
      connections.remove(c);
}

#ifdef emit
#undef emit
#endif

void BaseObject::_emit(const char *signal, PyObject *args)
{
  Connection *c;
  for(c = connections.first(); c!=0; c = connections.next())
    {
      if(strcmp(c->signal, signal) == 0)
	{
           PyObject *result = PyEval_CallObject(c->slot, args);
           if (!result)
             PyErr_Print();	      
           Py_XDECREF(result);
	}
    }
}

