#ifndef _LINEEDIT_H_
#define _LINEEDIT_H_

#include <Python.h>
#include "qlined.h"
#include "Baseobject.h"

class LineEdit : public QLineEdit, BaseObject
{
  Q_OBJECT	

  public:

    LineEdit(QWidget *parent=0, const char *name=0) : QLineEdit(parent,name), BaseObject() {
      connect(this, SIGNAL(textChanged(const char *)), this, SLOT(sigTextChanged(const char *)));
      connect(this, SIGNAL(returnPressed()), this, SLOT(sigReturnPressed()));
    };
    ~LineEdit() {};

  public slots:

    void sigReturnPressed() {
      _emit("pressed", 0);
    };
    
    void sigTextChanged(const char *text) {
      PyObject *arg = Py_BuildValue("(s)",text);
      _emit("textChanged", arg);
      Py_DECREF(arg);
    };
};    

#endif
