#ifndef _TOOLTIPGROUP_H_
#define _TOOLTIPGROUP_H_

#include <qtooltip.h>
#include "Object.h"
#include "Baseobject.h"


class ToolTipGroup : public QToolTipGroup, BaseObject
{
  Q_OBJECT
  
public:

  ToolTipGroup(QObject *parent=0, const char *name="") : QToolTipGroup(parent,name) 
  {
    connect(this, SIGNAL(showTip(const char *)), this, SLOT(sigShowTip(const char *)));
    connect(this, SIGNAL(removeTip()), this, SLOT(sigRemoveTip()));
  }
  
protected slots:

  void sigShowTip(const char *name) {
     PyObject *arg = Py_BuildValue("(s)",name);
     _emit("showTip", arg);  
     Py_DECREF(arg);
  }
  
  void sigRemoveTip() {
    _emit("removeTip", 0);
  };

};


#endif