/**********************************/
/* This file is part of QtC 0.0.2 */
/* (c) 1997 Roberto Alsina        */
/* Licensed under the GPL v2      */
/* Read file COPYING for details  */
/**********************************/
#include "qt_QColor.h"

qt_QColor *qt_new_QColor(){
	return (qt_QColor *)new QColor();
}
qt_QColor *qt_new_QColor1(int r,int g,int b)

{
	return (qt_QColor *) new QColor( (int)r,(int)g,(int)b );
}

qt_QColor *qt_new_QColor2(int x,int y,int z,int arg1)

{
    return (qt_QColor *) new QColor( (int)x,(int)y,(int)z,(QColor::Spec)arg1 );
}

qt_QColor *qt_new_QColor3(unsigned int rgb,unsigned int pixel)

{
	return (qt_QColor *) new QColor( (QRgb)rgb,(uint)pixel );
}

qt_QColor *qt_new_QColor4(char* name)

{
	return (qt_QColor *) new QColor( (char*)name );
}

qt_QColor *qt_new_QColor5(qt_QColor * arg1)

{
	return (qt_QColor *) new QColor( (QColor&)*arg1 );
}

void qt_del_QColor (qt_QColor *p)
{
delete (QColor*) p;
}

int qt_QColor_isValid( qt_QColor *instPointer){
	return (int)((QColor *)instPointer)->isValid();
}
int qt_QColor_isDirty( qt_QColor *instPointer){
	return (int)((QColor *)instPointer)->isDirty();
}
void qt_QColor_setNamedColor( qt_QColor *instPointer,char* name){
	((QColor *)instPointer)->setNamedColor((char* )name);
}
void qt_QColor_rgb( qt_QColor *instPointer,int r,int g,int b){
	((QColor *)instPointer)->rgb((int* )r,(int* )g,(int* )b);
}
unsigned int qt_QColor_rgb1( qt_QColor *instPointer){
	return (unsigned int)((QColor *)instPointer)->rgb();
}
void qt_QColor_setRgb( qt_QColor *instPointer,int r,int g,int b){
	((QColor *)instPointer)->setRgb((int )r,(int )g,(int )b);
}
void qt_QColor_setRgb1( qt_QColor *instPointer,unsigned int rgb){
	((QColor *)instPointer)->setRgb((QRgb )rgb);
}
int qt_QColor_red( qt_QColor *instPointer){
	return (int)((QColor *)instPointer)->red();
}
int qt_QColor_green( qt_QColor *instPointer){
	return (int)((QColor *)instPointer)->green();
}
int qt_QColor_blue( qt_QColor *instPointer){
	return (int)((QColor *)instPointer)->blue();
}
void qt_QColor_hsv( qt_QColor *instPointer,int h,int s,int v){
	((QColor *)instPointer)->hsv((int* )h,(int* )s,(int* )v);
}
void qt_QColor_setHsv( qt_QColor *instPointer,int h,int s,int v){
	((QColor *)instPointer)->setHsv((int )h,(int )s,(int )v);
}
qt_QColor * qt_QColor_light( qt_QColor *instPointer,int f){
	return (qt_QColor *)new QColor(((QColor *)instPointer)->light((int )f));
}
qt_QColor * qt_QColor_dark( qt_QColor *instPointer,int f){
	return (qt_QColor *)new QColor(((QColor *)instPointer)->dark((int )f));
}
int qt_QColor_lazyAlloc()
{
	return (int)QColor::lazyAlloc();
}
void qt_QColor_setLazyAlloc( int arg1)
{
	QColor::setLazyAlloc( (bool)arg1);
}
unsigned int qt_QColor_alloc( qt_QColor *instPointer){
	return (unsigned int)((QColor *)instPointer)->alloc();
}
unsigned int qt_QColor_pixel( qt_QColor *instPointer){
	return (unsigned int)((QColor *)instPointer)->pixel();
}
int qt_QColor_maxColors()
{
	return (int)QColor::maxColors();
}
int qt_QColor_numBitPlanes()
{
	return (int)QColor::numBitPlanes();
}
int qt_QColor_enterAllocContext()
{
	return (int)QColor::enterAllocContext();
}
void qt_QColor_leaveAllocContext()
{
	QColor::leaveAllocContext();
}
int qt_QColor_currentAllocContext()
{
	return (int)QColor::currentAllocContext();
}
void qt_QColor_destroyAllocContext( int arg1)
{
	QColor::destroyAllocContext( (int)arg1);
}
void qt_QColor_initialize()
{
	QColor::initialize();
}
void qt_QColor_cleanup()
{
	QColor::cleanup();
}
