// exercise1.cc
 
#include "artsflow.h"
#include "connect.h"
 
using namespace Arts;

int main()
{
    Dispatcher dispatcher;
 
    Synth_FREQUENCY freq1,freqmod;   // object creation
    Synth_WAVE_SIN  sin1,sinmod;
    Synth_MUL       mulmod;
    Synth_ADD       addmod;
    Synth_PLAY      play;
 
    // the modulation frequency
    setValue(freqmod, 0.3);
    connect(freqmod, sinmod);
 
    // bring it from the range [-1..1] to [-220..220]
    setValue(mulmod,"invalue1",220.0);
    connect(sinmod,mulmod,"invalue2");
 
    // add 440, to achieve the desired range: [220..660]
    setValue(addmod,"invalue1",440.0);
    connect(mulmod,addmod,"invalue2");
 
    // and use it as input for the beep generation
    connect(addmod,freq1);
    connect(freq1, sin1);         // object connection
 
    connect(sin1, play, "invalue_left");
    connect(sin1, play, "invalue_right");
 
    // start and go ;-)
    freq1.start(); freqmod.start();
    sin1.start(); sinmod.start();
    addmod.start(); mulmod.start();
    play.start();
    dispatcher.run();
}
