#include <stdio.h>

#include <qpopupmenu.h>
#include <qstringlist.h>

#include <kapp.h>
#include <kmenubar.h>
#include <kiconloader.h>
#include <kaction.h>
#include <kstdaction.h>

#include "kstdactionsdemo.moc"

KStdActionsDemo::KStdActionsDemo (const char *name) : KTMainWindow (name)
{

  //File menu
  KStdAction::openNew ( this, SLOT (slotNew()), actionCollection() );
  KStdAction::open ( this, SLOT (slotOpen()), actionCollection() );
  KStdAction::save ( this, SLOT (slotSave()), actionCollection() );

  recent = 
    KStdAction::openRecent ( 0, 0, actionCollection());
  recent->addURL (KURL("file:/samplepath/samplefile.txt"));
  recent->addURL (KURL("http://www.kde.org/sampleurl.html"));

  connect ( recent, SIGNAL (urlSelected (const KURL &)),
	    this, SLOT (slotRecent (const KURL &)) );

  KStdAction::quit (kapp, SLOT (closeAllWindows()), actionCollection());

  //Edit menu
  KStdAction::cut ( this, SLOT (slotCut()), actionCollection() );
  KStdAction::copy ( this, SLOT (slotCut()), actionCollection() );
  KStdAction::paste ( this, SLOT (slotCut()), actionCollection() );
  

  createGUI();

  QLabel *dummyclientarea = new QLabel (this);
  dummyclientarea->setBackgroundColor (Qt::white);
  setView (dummyclientarea);
}



void
KStdActionsDemo::slotNew()
{
  printf ("File->New\n");
}

void
KStdActionsDemo::slotOpen()
{
  printf ("File->Open\n");
}

void
KStdActionsDemo::slotSave()
{
  printf ("File->Save\n");
}

void
KStdActionsDemo::slotCut()
{
  printf ("Edit->Cut\n");
}

void
KStdActionsDemo::slotCopy()
{
  printf ("Edit->Copy\n");
}

void
KStdActionsDemo::slotPaste()
{
  printf ("Edit->Paste\n");
}

void
KStdActionsDemo::slotRecent (const KURL &url)
{
  printf ("Open recent file \"%s\"\n",
	  (const char *) url.url());
}
