/***************************************************************************
 *   Copyright (c) 2008  Jeff Mitchell <mitchell@kde.org>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/

#ifndef POPUPDROPPER_ITEM_P_H
#define POPUPDROPPER_ITEM_P_H

#include <QtDebug>
#include <QColor>
#include <QFont>
#include <QTimeLine>

class PopupDropperItemPrivate
{

public:

    PopupDropperItemPrivate( PopupDropperItem* parent );
    
    ~PopupDropperItemPrivate();

    PopupDropperAction* action;
    QString text;
    QTimeLine hoverTimer;
    QString elementId;
    QGraphicsTextItem* textItem;
    QGraphicsRectItem* borderRectItem;
    QGraphicsSvgItem* svgItem;
    QGraphicsRectItem* hoverIndicatorRectItem;
    QGraphicsRectItem* hoverIndicatorRectFillItem;
    int borderWidth;
    int hoverIndicatorRectWidth;
    QFont font;
    bool submenuTrigger;
    QColor baseTextColor;
    QColor hoveredTextColor;
    QColor hoveredBorderColor;
    QColor hoveredFillColor;
    QColor hoverIndicatorRectFillColor;
    bool hoveredOver;
    bool customBaseTextColor;
    bool customHoveredTextColor;
    bool customHoveredBorderColor;
    bool customHoveredFillColor;
    bool separator;
    QString file;
    QRect blankElementRect;
    int textOffset;
    PopupDropper* pd;

private:
    PopupDropperItem* q;
};

#endif

