/*
 * KMLOCfg
 *
 * A utility to configure modems of the ELSA MicroLink(tm) Office family.
 *
 * Copyright (C) 2000,2001,2002 Oliver Gantz <Oliver.Gantz@epost.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * ------
 * ELSA and MicroLink are trademarks of ELSA AG, Aachen, Germany.
 */

#include <stdlib.h>

#include <qglobal.h>
#include <qstring.h>

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <kuniqueapp.h>
#include <klocale.h>

#include "kmlocfg.h"


static const char *description =
	I18N_NOOP("A configuration utility for modems of the ELSA MicroLink(tm) Office family.");
	
	
int main(int argc, char *argv[])
{
	KAboutData aboutData("kmlocfg", I18N_NOOP("KMLOCfg"),
		VERSION, description, KAboutData::License_GPL,
		"(c) 2000,2001,2002 Oliver Gantz",
		I18N_NOOP("ELSA and MicroLink are trademarks of ELSA AG, Aachen, Germany."),
		"http://www.tu-bs.de/~y0000441/kmlocfg.html",
		"Oliver.Gantz@ePost.de");
	
	aboutData.addAuthor("Oliver Gantz", 0, "Oliver.Gantz@ePost.de");
	KCmdLineArgs::init(argc, argv, &aboutData);

	if (!KUniqueApplication::start())
		exit(0);

	KUniqueApplication a;
 
	KMLOCfg *kmlocfg = new KMLOCfg(0, "mainwindow");
	CHECK_PTR(kmlocfg);
	a.setMainWidget(kmlocfg);
	kmlocfg->setCaption(QString::null);
	kmlocfg->show();

	return a.exec();
}  
