#include "MultiTextInput.h"
#include <qcombobox.h>
#include <qlabel.h>
#include <qstring.h>
#include <qkeycode.h>
#include <qmlined.h>
#include <qscrollview.h>
#include <qframe.h>

#ifndef rcsid
static const char rcsid[]="$Id: MultiTextInput.cpp,v 2.13 2001/04/29 11:14:07 ral Exp $";
//const char*multitextinput_rcs(){return rcsid;}
#endif

#define Inherited CMultiTextInputData

CMultiTextInput::CMultiTextInput(QWidget* parent,const char* name)
    :Inherited( parent, name,true )
{
    setCaption( "KMySQL - MultiWindow" );
    EditList = 0;
    EditLayout = 0;
    FrameWidget = new QFrame(MainScrollView);
    /*    ScrollLayout = new QVBoxLayout(MainScrollView);
    ScrollLayout->setMargin(0);
    ScrollLayout->setSpacing(1);
    ScrollLayout->addWidget(FrameWidget);*/
    //    EditLayout = Q_CHILD(FrameWidget,QBoxLayout,"EditWidgets");
    FrameWidget->setMinimumSize(100,100);
    EditLayout = new QVBoxLayout(FrameWidget);
    EditLayout->setMargin(3);
    setMinimumSize(100,100);
}

CMultiTextInput::~CMultiTextInput()
{
    if (EditList)
	delete EditList;
}

//horrible - but I did not found any other way
//as such long functions
void CMultiTextInput::build_widgets(e_PatternList*which)
{
    QString s,t;

    QLineEdit*dummy;
    QMultiLineEdit*d2;
    QComboBox*d3;
    QLabel*d_label;
    QList<QLabel>*LabelList;
    QBoxLayout*d_layout;
    QSize hint;

    int x_label_size = 0;
    int y_label_size = 0;
    int x_size = 120;
    int MultiLineCount = 0;
    
    if (!which || which->size() == 0)
	return;
    EditList = new QList<QWidget>;
    LabelList = new QList<QLabel>;
    e_PatternIterator p_iterator;
    if (!EditLayout) {
	debug("could not find editlayout");
	return;
    }
    
    unsigned int n_y_pos = 0;
    for (p_iterator = which->begin();p_iterator!=which->end();++p_iterator){
	s = p_iterator->get_entry();
	d_layout = new QBoxLayout(QBoxLayout::LeftToRight, 2, NULL);
	if (p_iterator->isLargeText())
	    EditLayout->addLayout(d_layout,1);
	else
	    EditLayout->addLayout(d_layout,0);
	
	d_label = new QLabel(FrameWidget,s);
	d_label->setAlignment(AlignRight|AlignVCenter);
	t = s.copy();
	t +=": ";
	d_label->setText(t);
	hint=d_label->sizeHint();
	x_label_size = (hint.width() > x_label_size)?hint.width():x_label_size;
	y_label_size = hint.height();
	d_label->setMinimumSize(hint);
	d_label->setMaximumSize(hint);
	d_layout->addWidget(d_label);
	LabelList->append(d_label);
	if (p_iterator->isLargeText()) {
	    d2 = new QMultiLineEdit(FrameWidget,s);
	    d2->resize(30,50);
	    MultiLineCount++;
	    d2->setText(p_iterator->get_pattern());
	    EditList->append(d2);
	    if (which->begin() == p_iterator)
		d2->setFocus();
	    d_layout->addWidget(d2,1);
	    n_y_pos += 50;
	} else if (p_iterator->enum_list().size()>0) {
	    d3 = new QComboBox(FrameWidget,s);
	    d3->resize(30,25);
	    d3->setMinimumSize(10,25);
	    d3->setMaximumSize(32767,25);
	    if (which->begin() == p_iterator)
		d3->setFocus();
	    EditList->append(d3);
            d_layout->addWidget(d3);
	    n_y_pos+=25;
	    int cur_pos=-1;
	    for (unsigned _c=0;_c<p_iterator->enum_list().size();++_c) {
		d3->insertItem(p_iterator->enum_list()[_c].c_str());
		if (p_iterator->enum_list()[_c] == p_iterator->get_pattern()) {
		    cur_pos = _c;
		}
	    }
	    if (cur_pos>-1) {
		d3->setCurrentItem(cur_pos);
	    }
	} else {
	    dummy = new QLineEdit(FrameWidget,s);
	    dummy->resize(30,25);
	    dummy->setMinimumSize(10,25);
	    dummy->setMaximumSize(32767,25);
	    dummy->setText(p_iterator->get_pattern());
	    if (p_iterator->isNumeric()) {
		dummy->setMaxLength(29);
	    }
	    else 
		dummy->setMaxLength(255);
	    EditList->append(dummy);
            d_layout->addWidget(dummy);
	    if (which->begin() == p_iterator)
		dummy->setFocus();
	    connect( dummy, SIGNAL(returnPressed()), SLOT(change_focus()) );
	    n_y_pos+=25;
	}
	n_y_pos+=5;
    }
    for (d_label = LabelList->first();d_label;d_label = LabelList->next()) {
	d_label->setMinimumSize(x_label_size,y_label_size);
	d_label->setMaximumSize(x_label_size,y_label_size);
	d_label->resize(x_label_size,y_label_size);
    }
    x_label_size+=50;
    x_size = (x_size > x_label_size)?x_size:x_label_size;
    min_x = x_size*2;
    min_y = EditList->count()*28+MultiLineCount*30+10;
    FrameWidget->setMinimumSize(min_x,min_y);
    FrameWidget->setMaximumSize(32000,32000);
    FrameWidget->adjustSize();
    MainScrollView->setResizePolicy( QScrollView::AutoOne );
    MainScrollView->addChild(FrameWidget,0,0);
    //setMinimumSize(300,200);
    adjustSize();
    //resize(300,200);
    //ResizeFrame();
    delete LabelList;
}

PatternList*CMultiTextInput::get_entries(bool emptys_too)
{
    QWidget*currentEdit;
    PatternList*pattern_list;
    QString pat;
    QString name;

    pattern_list = new PatternList;
    for (currentEdit=EditList->first();currentEdit!=0;currentEdit=EditList->next()) {
	name = currentEdit->name();
	if (currentEdit->isA("QLineEdit")) {
	    pat = ((QLineEdit*)currentEdit)->text();
	} else if (currentEdit->isA("QComboBox")) {
	    pat = ((QComboBox*)currentEdit)->currentText();
	} else {
	    pat = ((QMultiLineEdit*)currentEdit)->text();
	}
	if ( (pat.length() > 0) || emptys_too)
	    pattern_list->push_back(CPatternPair(name,pat));
    }
    return pattern_list;
}

void CMultiTextInput::change_focus()
{
    focusNextPrevChild(true);
}

void CMultiTextInput::keyPressEvent(QKeyEvent*e)
{
    if (e->key() == Key_Return && (OkButton->hasFocus()) ) {
	e->accept();
	OkButton->animateClick();
	return;
    }
    if (e->isAccepted())
	return;
    QDialog::keyPressEvent(e);
}

void CMultiTextInput::resizeEvent ( QResizeEvent * e)
{
    CMultiTextInputData::resizeEvent(e);
    ResizeFrame();
}

void CMultiTextInput::ResizeFrame()
{
    int x = min_x > MainScrollView->width()?min_x:MainScrollView->width();
    int y = min_y > MainScrollView->height()?min_y:MainScrollView->height();
    QRect rect = MainScrollView->contentsRect();
    x = min_x > rect.width()?min_x:rect.width();
    y = min_y > rect.height()?min_y:rect.height();
    FrameWidget->resize(x,y);
}
