// $Id: progressdlg.cpp,v 2.3 2001/04/16 13:01:09 ral Exp $
#ifndef rcsid
static const char rcsid[]="$Id: progressdlg.cpp,v 2.3 2001/04/16 13:01:09 ral Exp $";
#endif

#include "progressdlg.h"
#include "kapp.h"
#include <qlabel.h>
#include <kprogress.h>

#define Inherited CProgressDlgData

CProgressDlg::CProgressDlg(QWidget* parent,const char* name)
    :Inherited( parent, name )
{
    setCaption( "Progress" );
    m_current = 0;
    m_Step = 0;
}

CProgressDlg::CProgressDlg(int min, int max, const char * text, QWidget* parent,const char* name)
    :Inherited( parent, name )
{
    m_Min = min;
    m_Max = max;
    setCaption( "Progress" );
    if (text)
	m_TitleText->setText(text);
}

CProgressDlg::~CProgressDlg()
{
}

void CProgressDlg::setMinMax(int min, int max,int step)
{
    m_Min = min;
    m_Max = max;
    m_Step = step;
}

void CProgressDlg::setPos(int pos)
{
    double _cur = (double)pos*100.0/(m_Max-m_Min);
    int cur = (int)(0.5+_cur);
    if (cur != m_current) {
	m_current = cur;
	m_Progress->setValue(cur);
	KApplication::kApplication()->processEvents(10);
    }
}

void CProgressDlg::setMainText(const char* text)
{
    if (!text)
	return;
    m_TitleText->setText(text);
}
