/*
 *  KSeg
 *  Copyright (C) 1999 Ilya Baran
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Send comments and/or bug reports to:
 *                 ibaran@mit.edu
 */


#include "G_object.H"

void G_pointObject::update()
{

  if(IS_TRANSFORM(where->getDescendType())) {
    point = parent(0)->getPoint();
  }

  switch(where->getDescendType()) {
  case G_TRANSLATED:
    point.translate(parent(2)->getPoint() - parent(1)->getPoint());
    break;
  case G_ROTATED: {
    double angle;

    angle = (parent(4)->getPoint() - parent(3)->getPoint()).angle() - (parent(2)->getPoint() - parent(3)->getPoint()).angle();

    point.rotate(parent(1)->getPoint(), angle);
    break;
  }
  case G_SCALED:
    point.scale(parent(1)->getPoint(), parent(3)->getSegment().length() / parent(2)->getSegment().length());
    break;
  case G_REFLECTED:
    point.reflect(*(parent(1)->getStraightRef()));
    break;
  case G_FREE_POINT:
    break;
  case G_CONSTRAINED_POINT:
    if(p == BIG) {
      point = parent(0)->getNearestPoint(point);
      p = parent(0)->getCurveRef()->getParamFromPoint(point);
    }
    else {
      point = parent(0)->getCurveRef()->getPointOnCurve(p);
    }
    break;
  case G_INTERSECTION_POINT:
    point = parent(0)->getCurveRef()->getIntersection(parent(1)->getCurveRef());
    break;
  case G_INTERSECTION2_POINT:
    point = parent(0)->getCurveRef()->getIntersection(parent(1)->getCurveRef(), 1);
    break;
  case G_MID_POINT:
    point = parent(0)->getSegment().getMidpoint();
    break;
  }

  if(!point.isValid()) where->setExists(false);

  return;
}

void G_pointObject::draw(QPainter &p)
{
  point.draw(p, *(where->getDrawstyle()), where->getSelected());
}

void G_pointObject::save(QDataStream &stream)
{ 
  if(where->getDescendType() == G_FREE_POINT) {
    stream << point; 
  }
  else if(where->getDescendType() == G_CONSTRAINED_POINT) {
    stream << p;
  }
}

void G_pointObject::load(QDataStream &stream) 
{ 
  if(where->getDescendType() == G_FREE_POINT) {
    stream >> point; 
  }
  else if(where->getDescendType() == G_CONSTRAINED_POINT) {
    stream >> p;
  }
}
