/*
 *  KSeg
 *  Copyright (C) 1999 Ilya Baran
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Send comments and/or bug reports to:
 *                 ibaran@mit.edu
 */


#include "G_object.H"
#include <stdio.h>

void G_segmentObject::update()
{

  if(IS_TRANSFORM(where->getDescendType())) {
    segment = parent(0)->getSegment();
  }

  switch(where->getDescendType()) {
  case G_TRANSLATED:
    segment.translate(parent(2)->getPoint() - parent(1)->getPoint());
    break;
  case G_ROTATED: {
    double angle;

    angle = (parent(4)->getPoint() - parent(3)->getPoint()).angle() - (parent(2)->getPoint() - parent(3)->getPoint()).angle();

    segment.rotate(parent(1)->getPoint(), angle);
    break;
  }
  case G_SCALED:
    segment.scale(parent(1)->getPoint(), parent(3)->getSegment().length() / parent(2)->getSegment().length());
    break;
  case G_REFLECTED:
    segment.reflect(*(parent(1)->getStraightRef()));
    break;
  case G_ENDPOINTS_SEGMENT:
    segment = G_segment(parent(0)->getPoint(), parent(1)->getPoint());
    break;
  }

  if(!segment.isValid()) where->setExists(false);

  return;
}

void G_segmentObject::draw(QPainter &p)
{
  segment.draw(p, *(where->getDrawstyle()), where->getSelected());
}




