/***************************************************************************
                          touchlecture.cpp  -  description
                             -------------------
    begin                : Sun Dec 10 2000
    copyright            : (C) 2000 by Haavard Froeiland
    email                : haavard@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "touchlecture.h"
#include <iostream.h>
#include <fstream.h>
#include <stdlib.h>


#define BUFLEN 256

TouchLecture::TouchLecture()
{
	fileName="";
  level=0;
	pos=0;
};

TouchLecture::~TouchLecture()
{
};

const char* TouchLecture::getName()
{
 	return fileName;
}

void TouchLecture::loadLectureFile(QString f)
{
  fileName=f;
  unsigned int maxLevel=0;
  levelVector.clear();
  ifstream ifs(fileName, ios::in);
  if (!ifs) {
    cerr << "Error: unable to open " << fileName << endl;
    fileName="<none>";
  }
  else
	{
		char buffer[BUFLEN];

  	levelVector.insert(levelVector.end(),new vector<const char*>);
  	while (!ifs.eof()) {
    	ifs.getline(buffer, sizeof(buffer), '\n');
    	if (!(ifs.eof() && strlen(buffer) == 0)){
      	if(!(buffer[0]=='#'))
				{
        	if(strlen(buffer) == 0)
					{
            if(!(levelVector[maxLevel]->empty()))
            {
          		levelVector.insert(levelVector.end(),new vector<const char*>);
							maxLevel++;
//              cout << "Level read: " << maxLevel << endl;
            }
					}
					else
					{
          	char *fitte=new char[strlen(buffer)+1];
          	for(unsigned int i=0;i<strlen(buffer);i++)
						{
							fitte[i]=buffer[i];
						}
            fitte[strlen(buffer)]='\0';
        		levelVector[maxLevel]->insert(levelVector[maxLevel]->end(),fitte);
					}
    		}
    	}
    }
    if(levelVector[maxLevel]->empty())
	  {
   	 	levelVector.erase(&levelVector[maxLevel]);
      maxLevel--;
		}
    setLevel(level);
    pos=0;
  }
};

const char * TouchLecture::getNextLine()
{
  cout << pos << endl;
  if (levelVector.empty())
	{
    return "No file loaded";
	}
  if(level<(levelVector.size()))
  {
     vector<const char *> test=*levelVector[level];

     if (pos>=(test.size()-1))
	   {
		   pos=0;
	   }
     return test[pos++];
  }
  return "Error in getNextLine()";
};


void TouchLecture::levelUp()
{
  if(level<(levelVector.size()-1))
	{
		level++;
    emit levelChanged(level);
		
		//is good to start at pos 0 every time you change level?
	  pos=0;
	}
};

void TouchLecture::levelDown()
{
  if(level>0)
	{
		level--;
    emit levelChanged(level);
		
		//is good to start at pos 0 every time you change level?
  	pos=0;
	}

};

void TouchLecture::setLevel(unsigned int l)
{
	if(l<(levelVector.size()))
	{
   	level=l;
		emit levelChanged(level);
  }
  else
  {
    level=levelVector.size()-1;
    setLevel(level);
  }
};

