/***************************************************************************
                          kboard.cpp  -  description
                             -------------------
    begin                : Sun Nov 11 2001
    copyright            : (C) 2001 by Jos?Pablo Fern?dez
    email                : jpablo@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

 #include <qlayout.h>
 #include <iostream.h>
 #include <stdlib.h>
 #include <kapp.h>

#include "kboard.h"

#include "ksquare.h"

KBoard::KBoard(QWidget *parent, const char *name, int num_rows, int num_cols,
	QArray<KSquare::Background> background,
	QArray<KSquare::State> squares) : QWidget(parent,name)
{
	int i ;
	int j ;

selected = false ;
rows = num_rows ;
cols = num_cols ;
square_selected = 0 ;


/* As da un error de desbordamiento de memoria al crear el vector y un kcrash */
/* squares = QVector<KSquare> (rows*cols) ; */

KBoard::squares = QArray<KSquare *> (rows*cols) ;


QGridLayout *layout = new QGridLayout (this, rows, cols ) ;

for (i=0; i < rows; i++)
	for (j=0; j< cols; j++) {
		KSquare *square_i_j = new KSquare(this, "square_i_j",
			background[i*rows+j],
			squares[i*rows+j], i, j);
		KBoard::squares[rows*i+j] = square_i_j ;
		layout->addWidget (square_i_j, i, j) ;
		connect (
			square_i_j,
			SIGNAL(changeRequest(KSquare::State, KSquare *)),
			SLOT (processClicks (KSquare::State, KSquare *))) ;
	}
	
}

KSquare *KBoard::getSquare(int i, int j)
{
	return KBoard::squares[i*rows+j] ;
}



void KBoard::processClicks (KSquare::State state,  KSquare *square)
{
	emit sigClick(state, square) ;
}

bool KBoard::getSelected() {
	return selected ;
}

KSquare *KBoard::getSquareSelected() {
	return square_selected ;
}

void KBoard::select(KSquare *square) {
	square->select() ;
	selected = true ;
	square_selected = square ;
 	row_selected = square->getRow() ;
	col_selected = square->getCol() ;
	square->update() ;
}
	


void KBoard::unselect(KSquare *square) {
	square->unselect() ;
	selected = false ;
	square_selected = 0 ;
 	row_selected = 0 ;
	col_selected = 0  ;
	square->update() ;
}

void KBoard::tip(KSquare *square) {
	square->tip() ;
	list_tiped.prepend(square) ;
}

void KBoard::untipAll() {
	KSquare *square ;
	while (!list_tiped.isEmpty()) {
		square = list_tiped.take(0) ;
		square->untip() ;
	}
}

KBoard::~KBoard() {
}
