/***************************************************************************
                          ksquare.h  -  description
                             -------------------
    begin                : Sat Nov 10 2001
    copyright            : (C) 2001 by Jos?Pablo Fern?dez
    email                : jpablo@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSQUARE_H
#define KSQUARE_H

#include <qwidget.h>

/**
  *@author Jos?Pablo Fern?dez
  */

class KSquare : public QWidget  {
   Q_OBJECT
public:
	enum State {Non, X, O, SmallCircle, Empty } ;
	enum Background {BgNon, BgBlack, BgWhite, BgSmallCircle} ;
	
	KSquare(QWidget *parent=0, const char *name=0,
		KSquare::Background=KSquare::BgNon,
		KSquare::State=KSquare::Non, int i=0, int j=0); 	
	~KSquare(); 	int
	getRow(void) ; 	
	int getCol(void) ; 	
	KSquare::State getState(void) ;
	bool select(void) ;
	bool unselect(void) ;	
	bool isSelected(void) ;
	void tip(void) ;
	void untip(void) ;
			
public slots:
	void setState(KSquare::State state) ;
	void setBackground(KSquare::Background background) ;
	
signals:
	void changeRequest (KSquare::State state, KSquare *);
	
protected:
	/* Repintar la casilla */	
	void paintEvent (QPaintEvent *) ;
	
	/* Procesar la pulsacion con el raton */
	void mousePressEvent (QMouseEvent *) ;
	
private:
	int row ;
	int col ;
	
	bool selected ;
	bool tiped ;
	
	State state ;
	Background background ;
};

#endif
