/***************************************************************************
                          kpeggy.cpp  -  description
                             -------------------
    begin                : jue nov  8 22:42:52 CET 2001
    copyright            : (C) 2001 by Jos Pablo Fernndez
    email                : jpablo@di.uc3m.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <kstdaccel.h>
#include <kiconloader.h>
#include <kmenubar.h>
#include <kapp.h>
#include <kaction.h>
#include <klineedit.h>
#include <kstdaction.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kstddirs.h>

#include <stdlib.h>
#include <stdio.h>

#include <unistd.h>

#include <qarray.h>

#include "kpeggy.h"
#include "peggydata.h" /* vacia, Ocupada */
#include "astar.h"
#include "ksquare.h"


KPeggy::KPeggy(QWidget * widget, const char *name) : KMainWindow(0, name)
{

statusBar()->insertItem(i18n("Ready."), ID_STATUS_MSG, this->size().width()) ;

gameNew = KStdAction::openNew (this, SLOT (slotNew()),actionCollection()) ; 		
gameQuit = KStdAction::quit (this, SLOT(slotFileQuit()),actionCollection()) ; 		
gameTip = new KAction(i18n("&Hint"), QIconSet(BarIcon("idea")), Key_H,this, SLOT(slotTip()), actionCollection(), "file_tip");
gameDemo = new KAction(i18n("&Demo"), 0, Key_D,this, SLOT(slotDemo()), actionCollection(), "file_demo");
/*
editUndo = KStdAction::undo (this, SLOT(slotUndo()),actionCollection()) ; 		
editRedo = KStdAction::redo (this, SLOT(slotRedo()),actionCollection()) ; 		
*/

viewToolBar = KStdAction::showToolbar(this,SLOT(slotViewToolBar()), actionCollection()) ; 		
viewStatusBar =KStdAction::showStatusbar(this,SLOT(slotViewStatusBar()), actionCollection()) ; 		
viewMenuBar =KStdAction::showMenubar(this,SLOT(slotViewMenuBar()), actionCollection()) ; 		
/*
viewPreferences =KStdAction::preferences(this,SLOT(slotPreferences()), actionCollection()) ; 		
*/
viewStatusBar->setStatusText(i18n("Enables/disables the statusbar"));
viewToolBar->setStatusText(i18n("Enables/disables the toolbar"));

createGUI() ;

kboard = 0 ;
I = 0 ;

/* Images and backgrounds */
backgrounds = QArray<QImage *> (2) ;
images = QArray<QImage *> (3) ;
QImage *image ;
KStandardDirs *dirs=KGlobal::dirs() ;

image = new QImage() ;
if (!image->load(dirs->findResource("data", "kpeggy/pics/background.png")))
	cout << "error loading background.png" << endl ;
backgrounds[0] = 0 ;
backgrounds[1] = image ;

image = new QImage() ;
if (!image->load(dirs->findResource("data", "kpeggy/pics/stone.png")))
	cout << "error loading stone.png"  << endl ;
images[0] = 0 ;
images[1] = 0 ;
images[2] = image ;

setMinimumSize(7*40, 7*40) ;
setMaximumSize(7*40, 7*40) ;
}


void KPeggy::slotNew()
{

int num_rows = 7 ;
int num_cols = 7 ;

int i, j ; /* indices para recorrer filas y columnas */


/* Construyo el array de fichas y del background */
QArray<KSquare::Background> mi_background ;
mi_background = QArray<KSquare::Background> ( num_rows*num_cols);

/* QArray<KSquare::State> squares( num_rows*num_cols); */

QArray<KSquare::State> mi_squares ;
mi_squares = QArray<KSquare::State> ( num_rows*num_cols);


for (i=0; i< num_rows; i++) {
	for (j=0; j<num_cols; j++) {
		if ( ((i<2 || i>4) && (j <2 || j>4)) ) {
			mi_background[ (i*num_rows+j) ] = KSquare::BgNon ;
			mi_squares[i*num_rows+j] = KSquare::Non ;
			/* mi_squares[(i*num_rows+j)] = KSquare::Empty ; */
		} else {
			mi_background[i*num_rows+j] = KSquare::BgSmallCircle ;
			if (i==3 && j==3)
				mi_squares[i*num_rows+j] = KSquare::Empty ;
			else
				mi_squares[i*num_rows+j] = KSquare::SmallCircle ;
		}
	}
}

		
delete kboard ;	


kboard = new KBoard(this, "kpeggy", num_rows, num_cols, mi_background, mi_squares,
	40, backgrounds, images) ;
setCentralWidget(kboard) ;

connect (
	kboard, SIGNAL(sigClick(KSquare::State, KSquare *)),
	SLOT(slotClick(KSquare::State, KSquare *))
) ;

delete I ;
I=new PeggyData();
I->init() ;
}

void KPeggy::slotClick (KSquare::State state,  KSquare *square)
{
	KSquare *square_selected ;
	KSquare *square_mid ;
	
	int row, col ;
	int row_mid, col_mid ;
	int row_selected, col_selected ;
	
	if (!kboard->getSelected()) {
		/* Si no esta ocupada, no se puede seleccionar */
		if (square->getState() != KSquare::SmallCircle) {
			slotMsg(i18n("It is not posible to select a empty square")) ;
			return ;
		}
		kboard->select(square) ;
	} else {
		/* Si volvemos a selecionar la misma, la deselecionamos */
		if (square->isSelected()) {
			kboard->unselect(square) ;
			return ;
		}
		/* Si la casilla esta ocupada no es posible el movimiento */
		if (square->getState() != KSquare::Empty) {
			slotMsg(i18n("Destination square is not empty")) ;
			return ;
		}
		
		row = square->getRow() ;
		col = square->getCol();

		square_selected = kboard->getSquareSelected() ;
		row_selected = square_selected->getRow() ;
		col_selected = square_selected->getCol() ;

		if ( ( abs(row_selected-row) != 2 && abs(col_selected-col) != 2 ) ||
			(row_selected != row && col_selected != col) ) {
			slotMsg(i18n("This movement is not posible")) ;
			return ;
		}

		square_mid = kboard->squareMid(square_selected, square) ;
		row_mid = square_mid->getRow()   ;
		col_mid = square_mid->getCol()  ;
		
		/* Si la casilla del medio no esta ocupada, no es posible el movimiento */
		if (square_mid->getState() != KSquare::SmallCircle ) {
			slotMsg(i18n("This movement is not posible: middle square is empty")) ;
			return ;	
		}
		
		kboard->unselect(square_selected) ;

		kboard->move(square_selected, square) ;
		square_mid->setState(KSquare::Empty, images[1]) ;

		I->set(row_selected, col_selected, Vacia) ;
		I->set(row_mid, col_mid, Vacia) ;
		I->set(row, col, Ocupada) ;
		I->set_g(I->get_g()+1) ;
		I->set_h(I->calculate_h()) ;

		/* DEBUG I->print() ; */

		kboard->untipAll() ;

		if (I->isGoal()) {
			slotMsg(i18n("You Win!")) ;
			return ;					
		}
	
		if (I->sucesors() == null) {
			slotMsg(i18n("You lost!. There is no more posible movements")) ;
			return ;					
		}


	}  /* else (!selected) */
		
}


KPeggy::~KPeggy()
{
}


void KPeggy::slotFileQuit()
{
	close();
}

void KPeggy::slotUndo()
{
}

void KPeggy::slotRedo()
{
}

void KPeggy::slotViewToolBar()
{
	slotStatusMsg(i18n("Toggling the toolbar..."));
	//turn Toolbar on or off
	if (!viewToolBar->isChecked())
	{
		toolBar("mainToolBar")->hide();
	} else {
		toolBar("mainToolBar")->show();
	}
	slotStatusMsg(i18n("Ready."));
}

void KPeggy::slotViewStatusBar()
{
	slotStatusMsg(i18n("Toggle the statusbar..."));
	//turn Statusbar on or off
	if (!viewStatusBar->isChecked())
	{
		statusBar()->hide();
	} else {
		statusBar()->show();
	}
	slotStatusMsg(i18n("Ready."));
}

void KPeggy::slotViewMenuBar()
{
	slotStatusMsg(i18n("Toggle the menubar..."));
	//turn Menubar on or off
	if (!viewMenuBar->isChecked())
	{
		menuBar()->hide();
	} else {
		menuBar()->show();
	}
	slotStatusMsg(i18n("Ready."));
}


void KPeggy::slotPreferences()
{
}

void KPeggy::slotStatusMsg(const QString &text)
{
	// change status message
	statusBar()->clear() ;
	statusBar()->changeItem(text, ID_STATUS_MSG);

}

void KPeggy::slotMsg(const QString &text)
{
	KMessageBox *msgBox = new KMessageBox () ;
	msgBox->sorry(this, text) ;
	delete msgBox ;
}

void KPeggy::slotTip()
{
       AStar astar ;
	PeggyData *I2 ;

	slotStatusMsg(i18n("Tip")) ;

	Tree<PeggyData> *best ;
	PeggyData	*best_data ;
	KSquare *square ;
	bool sucess ;

	/* DEBUG Matrix<int> matriz (7, 7) ; */
	I2 = new PeggyData(*I) ;
	astar.init(I2) ;
	sucess = astar.resolve(226) ;
/*	sucess = astar.resolve(100000) ; */
	best = (Tree<PeggyData> *)astar.best() ;

	/* BUG KCrash when (best == null) in best->data() */
	if (best == null)
		return ;

	best_data = best->data() ;	
	/* DEBUG
	matriz = best_data->get_matriz() ;
	matriz.print() ;
	*/

	square = kboard->getSquare(best_data->start_x, best_data->start_y ) ;
	kboard->tip(square) ;

	square = kboard->getSquare(best_data->end_x, best_data->end_y ) ;
	kboard->tip(square) ;
	
}


void KPeggy::slotDemo()
{
       AStar astar ;
	PeggyData *I2 ;

	slotStatusMsg(i18n("Demo")) ;

	Tree<PeggyData> *best ;
	PeggyData	*best_data ;
	bool sucess ;
	bool end ;

	KSquare *square_start ;
	KSquare *square_end ;
	KSquare *square_mid ;
	int row_start, col_start ;
	int row_end, col_end ;
	int row_mid, col_mid ;

	kboard->untipAll() ;
	end = false ;	
//while (!end)  {
	I2 = new PeggyData(*I) ;	
	astar.init(I2) ;
	sucess = astar.resolve(226) ;
	best = (Tree<PeggyData> *)astar.best() ;

	if (best == null)
		return ;

	best_data = best->data() ;	

	square_start = kboard->getSquare(best_data->start_x, best_data->start_y ) ;
	kboard->select(square_start) ;
	row_start = square_start->getRow() ;
	col_start = square_start->getCol() ;

	square_end = kboard->getSquare(best_data->end_x, best_data->end_y ) ;
	kboard->select(square_end) ;
	row_end = square_end->getRow() ;
	col_end = square_end->getCol() ;

	square_mid = kboard->squareMid(square_start, square_end ) ;
	row_mid = square_mid->getRow() ;
	col_mid =  square_mid->getCol() ;

	kapp->processEvents() ;
	sleep (1) ;

	square_start->setState(KSquare::Empty, images[1]) ;
	square_mid->setState(KSquare::Empty, images[1]) ;
	square_end->setState(KSquare::SmallCircle, images[2]) ;

	I->set(row_start, col_start, Vacia) ;
	I->set(row_mid, col_mid, Vacia) ;
	I->set(row_end, col_end, Ocupada) ;
	I->set_g(I->get_g()+1) ;
	I->set_h(I->calculate_h()) ;

	kboard->unselect(square_start) ;		
	kboard->unselect(square_end) ;		

	kapp->processEvents() ;
	sleep (1) ;

	/* I->print() ; DEBUG */
	
//}

}
