/***************************************************************************
                          tree.h  -  description
                             -------------------
    begin                : Wed Nov 14 2001
    copyright            : (C) 2001 by Jos Pablo Fernndez
    email                : jpablo@di.uc3m.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TREE_H
#define TREE_H

/**
  *@author Jos Pablo Fernndez
  */

#define null 0

template<class type>
class Tree {
public: 
	Tree(type *data = null) {
		Tree::the_data = data ;
		the_parent = null ;
		the_son = null ;
		the_brother = null ;
	}	
	
	~Tree() {
		if (the_data != null) delete (the_data) ;
		if (the_son != null) delete (the_son) ;
		if (the_brother != null) delete (the_brother) ;
	} /* is needed ? */
	
	void insertBrother(type *data) {
		Tree *aux ;
		aux = new Tree(data) ;
		aux->the_parent = Tree::the_parent ;
		aux->the_son = null ;
		aux->the_brother = Tree::the_brother ;
		Tree::the_brother = aux ;

	}
	
	void insertSons(Tree *sons) {
		Tree *aux ;		
		Tree::the_son = sons ;
		
		for (aux = sons; aux != null; aux = aux->the_brother) {
				aux->the_parent = this ;
		}
	}
	
	type *data() {	return the_data ;	}
	Tree *son() { return the_son ; }
	Tree *brother() { return the_brother; }
	Tree *parent() { return the_parent ; }	
	
private:
	type  *the_data ;
	Tree *the_parent ;
	Tree *the_son ;
	Tree *the_brother ;
};

#endif
