#ifndef KGAMEWIDGET_H 
#define KGAMEWIDGET_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <qwidget.h>

#include <qpoint.h>
#include <qpixmap.h>
#include <qevent.h>
#include <qtimer.h>

class KPuzzleWidget;
class KPuzzleApp;

class KGameWidget : public QWidget
{
	Q_OBJECT
 public:
	KGameWidget(QWidget *parent,KPuzzleApp* app);
	virtual ~KGameWidget();
	void initialize(QSize picSize);

// Data
 public:
	QPoint& scrollPos() { return _scrollPos; }
	char moveKeyPressed() { return _moveKeyPressed; }

 protected:
	QPoint piecePos() { return _piecePos; }
	QRect pieceRect();

	QPoint _scrollPos;
	KPuzzleApp* _app;
	QPoint _piecePos; // Position of the piece currently moved, -1/-1 if there is none
	QTimer* _moveTimer;
	char _moveKeyPressed;

// Implementation
 public:


 protected:
	virtual void paintEvent(QPaintEvent* event);
	virtual void mouseMoveEvent(QMouseEvent* event);
	virtual void mousePressEvent(QMouseEvent* event);
	virtual void leaveEvent(QEvent*);
	
	QPoint calculatePiecePos(QPoint p);

	QPoint LPtoDP(QPoint pt) { return pt - scrollPos(); }
	QPoint DPtoLP(QPoint pt) { return pt + scrollPos(); }
	QRect LPtoDP(QRect r) { return QRect(LPtoDP(r.topLeft()),LPtoDP(r.bottomRight())); }
	QRect DPtoLP(QRect r) { return QRect(DPtoLP(r.topLeft()),DPtoLP(r.bottomRight())); }

 public slots:
	void slotLeftPress();
	void slotLeftRelease();
	void slotRightPress();
	void slotRightRelease();
	void slotUpPress();
	void slotUpRelease();
	void slotDownPress();
	void slotDownRelease();

	void slotMoveTimer();

	void slotShowAt(QPoint pos);

 signals:
	void sigShowAt(QPoint pos);
};

#endif // KGAMEWIDGET_H 
