#include "main.h"

#include "prefs.h"

#include "kpuzzle.h"

CPrefsDialog::CPrefsDialog(QWidget* parent) : QDialog(parent,0,true)
{
	_mask = new QCheckBox("Use piece &mask",this);
	_mask->setFixedWidth(150);

	_turn = new QCheckBox("&Turn pieces around",this);
	_turn->setFixedWidth(150);

	_loading = new QButtonGroup("Load images",this);
	_ilOnUse = new QRadioButton("&On use",_loading);
	_ilOnUse->move(20,20);
	_ilOnUse->setFixedWidth(100);
	_ilKeep = new QRadioButton("&Keep",_loading);
	_ilKeep->move(20,_ilOnUse->y() + _ilOnUse->height() + 10);
	_ilKeep->setFixedWidth(100);
	_ilPreload = new QRadioButton("&Preload",_loading);
	_ilPreload->move(20,_ilKeep->y() + _ilKeep->height() + 10);
	_ilPreload->setFixedWidth(100);

	_loading->setFixedWidth(200);
	_loading->setFixedSize(QSize(150,_ilPreload->y() + _ilPreload->height() + 20));

	_ok = new QPushButton("OK",this);
	_ok->setDefault(true);
	connect(_ok,SIGNAL(clicked()),this,SLOT(accept()));
	_cancel = new QPushButton("Cancel",this);
	connect(_cancel,SIGNAL(clicked()),this,SLOT(reject()));

	_buttons = new QHBoxLayout(20);

	_elements = new QVBoxLayout(this,20);
	_elements->addWidget(_mask);
	_elements->addWidget(_turn);
	_elements->addWidget(_loading);
	_elements->addLayout(_buttons);

	_buttons->addWidget(_ok);
	_buttons->addWidget(_cancel);

	_elements->activate();

	resize(260,320);
}

CPrefsDialog::~CPrefsDialog()
{
	delete _buttons;
	delete _elements;
	delete _ilOnUse;
	delete _ilKeep;
	delete _ilPreload;
	delete _loading;
	delete _mask;
	delete _turn;
}

void CPrefsDialog::setValues()
{
	_mask->setChecked(_usePieceMask);
	_turn->setChecked(_turnPiecesAround);
	_ilOnUse->setChecked(_imageLoading == IL_ON_USE);
	_ilKeep->setChecked(_imageLoading == IL_KEEP);
	_ilPreload->setChecked(_imageLoading == IL_PRELOAD);
}

void CPrefsDialog::retrieveValues()
{
	_usePieceMask = _mask->isChecked();
	_turnPiecesAround = _turn->isChecked();
	_imageLoading = (_ilOnUse->isChecked() ? IL_ON_USE : (_ilKeep->isChecked() ? IL_KEEP : IL_PRELOAD));
}
