/***************************************************************************
    Description          : KPuzzle - A KDE Jigsaw Puzzle Game
    Version              : 0.2
    Copyright            : (C) 2000-2001 by Michael Wand
    EMail                : mwand@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MAIN_H
#define MAIN_H

#include <qglobal.h>
#include <kglobal.h>
#include <klocale.h>
#include <kstddirs.h>
#include <qstring.h>
#include <qstringlist.h>

#define LEVELS_DIR ((KGlobal::dirs()->findDirs("appdata","levels")).first())
#define DATAFILE(a) (KGlobal::dirs()->findResource("data",a))
#define PICFILE(a) (KGlobal::dirs()->findResource("pics",a))

#define MOVE_TIMER_INTERVAL 100
#define VISIBLE_PIXMAP_SIZE 450

// Menu items to be enabled/disabled
#define MI_NONE 0x0
#define MI_STOP_GAME 0x0001
#define MI_PAUSE 0x0002
#define MI_SHOW_LARGE 0x0004
#define MI_SAVE_GAME 0x0008

// How to load images
// Preload all
#define IL_PRELOAD 2
// Keep images when loaded once
#define IL_KEEP 1
// Delete images after use
#define IL_ON_USE 0

// Standard values
#define SV_USE_PIECE_MASK 1
#define SV_TURN_PIECES_AROUND 1
#define SV_RIGHT_KEY_PANS_AROUND 1
#define SV_IMAGE_LOADING IL_PRELOAD
#define SV_PLAYER_NAME ""
#define SV_SHOW_MAIN_PIXMAP 0

// Filenames and anchors for help invocation
#define HF_CONTENTS "kpuzzle/index.html"
#define HF_PREREQUISITES "kpuzzle/cont-1.html"
#define HF_INSTALL "kpuzzle/cont-1.html"
#define HF_GAME "kpuzzle/cont-2.html"
#define HF_GAME_END "kpuzzle/cont-2.html"
#define HF_MAIN_SCREEN "kpuzzle/cont-3.html"
#define HF_FUNCTIONS "kpuzzle/cont-3.html"
#define HF_DIALOG_NEW "kpuzzle/cont-4.html"
#define HF_DIALOG_OPEN "kpuzzle/cont-4.html"
#define HF_DIALOG_SAVE "kpuzzle/cont-4.html"
#define HF_DIALOG_NEWGAME "kpuzzle/cont-4.html"
#define HF_DIALOG_SAVEGAME "kpuzzle/cont-4.html"
#define HF_DIALOG_PROPERTIES "kpuzzle/cont-4.html"
#define HF_COMMANDS "kpuzzle/cont-3.html"
#define HF_EPILOGUE "kpuzzle/cont-5.html"

#define HA_CONTENTS QString::null
#define HA_PREREQUISITES QString::null
#define HA_INSTALL QString::null
#define HA_GAME "game"
#define HA_GAME_END "end"
#define HA_MAIN_SCREEN "mainscreen"
#define HA_FUNCTIONS "functions"
#define HA_DIALOG_NEW "kfile"
#define HA_DIALOG_OPEN "kfile"
#define HA_DIALOG_SAVE "kfile"
#define HA_DIALOG_NEWGAME "newgame"
#define HA_DIALOG_SAVEGAME "savegame"
#define HA_DIALOG_PROPERTIES "properties"
#define HA_COMMANDS "commands"
#define HA_EPILOGUE QString::null

#define min(a,b) ((a) < (b) ? (a) : (b))
#define max(a,b) ((a) > (b) ? (a) : (b))

/*QTextStream& operator<<(QTextStream& f,const QSize& sz) */

#endif // MAIN_H
