/***************************************************************************
                          ktuxpop.cpp  -  description
                             -------------------
    begin                : lun avr 17 13:02:59 CEST 2000
    copyright            : (C) 2000 by Mickal Marchand
    email                : MikMak@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for QT
#include <qdir.h>
#include <qstrlist.h>
#include <qpainter.h>
#include <unistd.h>
#include <errno.h>
extern int errno;
#include <stdio.h>

// include files for KDE
#include <kiconloader.h>
#include <kmsgbox.h>
#include <kfiledialog.h>

// application specific includes
#include "ktuxpop.h"
#include "resource.h"

extern bool replyer;
extern bool beeper;
extern int restaurer;
extern bool loguer;
extern bool showlogo;
extern bool filtrer_all;
extern bool filtrer_groupe;
extern bool filtrer_persos;
extern bool filtre_actif;
QStrList filtre_perso;
QStrList my_alias;
QStrList existing_alias;
extern QString appdir;
QString hostname;
QStrList favoris;
QStrList liste_groupes;
QString MYIP;
QString workgroup;
QStrList messages_repondeur;
QString BROAD_ADDR;
QList<people> list_people;
QString ORIG_ALIAS;
QString DEST_ALIAS;
QString MSG_ALIAS;
QString IP_ALIAS;
extern QTime timer_browse;
bool starting;


KTuxPop::KTuxPop()
{
	
  config=kapp->getConfig();


  recus = new Reception();

	config->setGroup("General");
	BROAD_ADDR = config->readEntry("Broadcast","000.000.000.000");
	if (config->readBoolEntry("Install",true)) //first install
	{
	showStartupConfig();
	char name[256];
		if (gethostname(name,255)==-1){
			KMsgBox::message(0,"Hostname problem","KTuxPop cannot find your hostname",0,0);
			exit(1);
		}
	hostname = name;
	hostname = hostname.upper();
	if (hostname.length()>15) hostname.truncate(15);
	//show netbios name selection window to confirm name
	install = new firstinstall();
	install->show();
	hostname = hostname.upper();
	favoris.append("ALL-POPUP");
	favoris.append(workgroup);
	}
	else {
	workgroup = config->readEntry("Workgroup","");
  hostname = config->readEntry("Hostname","");
	}

	/*rcupration de l'ip locale*/
	struct hostent *myhost;
	char **addrs;
	myhost = gethostbyname(hostname);
	if (!myhost) {
		perror("gethostbyname");
		exit (1);
	}
	addrs= myhost->h_addr_list;
	MYIP=inet_ntoa(*(struct in_addr *)*addrs);
 	
	initSockets();

	starting = true;
  readOptions();
  initMenuBar();
  initToolBar();
  initKeyAccel();
	initTabs();
  initStatusBar();

	ORIG_ALIAS = "";
	DEST_ALIAS = "";
	MSG_ALIAS = "";
	IP_ALIAS = "";
	liste_groupes.append(workgroup);

	/*noms persos*/
	perso1 = ';' + hostname;
	perso2 = hostname + ';';
	hostname2 = "\\\\" + hostname;
	perso3 = ';' + hostname2;
	perso4 = hostname2 + ';';

	/*noms groupe*/
	group1 = ';' + workgroup;
	group2 = workgroup + ';';
	grpe2 = "\\\\" + workgroup;
	group3 = ';' + grpe2;
	group4 = grpe2 + ';';

	/*noms all*/
	toutlemonde="TOUT LE MONDE";
	touslesgens="TOUS LES GENS";
	all="ALL";
	allpopup="ALL-POPUP";
	etoile="*";	

	mess_precedent = "";
	orig_precedent = "";
	dest_precedent = "";

	popup = new Popups();
  list_people.setAutoDelete( TRUE );

  pthread_attr_t thread_attr;
	if (pthread_attr_init(&thread_attr) != 0) {
	KMsgBox::message (0,"threading problem","init thread",0,0);
	exit (1);
	}
	if (pthread_attr_setdetachstate (&thread_attr, PTHREAD_CREATE_DETACHED) != 0) {
	KMsgBox::message (0,"threading problem","attr thread",0,0);
	exit (1);
	}
	if (pthread_create(&scan_alias, NULL, thread_alias, NULL)<0){
	KMsgBox::message (0,"threading problem","create thread",0,0);
	exit (1);
	}
	popup->InitSalup();

	timer_browse.start();

if (showlogo && !recus->nombre_popups_total) SetLogo();	

	/*initialisation fichier reception messages samba*/
/*int file_handle;
if (access (appdir+"/ktuxpop/ktuxpop.msg", F_OK))
{
  file_handle = open (appdir+"/ktuxpop/ktuxpop.msg", O_WRONLY | O_CREAT, DATA_PERM);
	close (file_handle);
	FILE *output2;
	char command_line2[38] = "chown nobody:nogroup /tmp/ktuxpop.msg";
	output2 = popen (command_line2, "r");
	fread (command_line2, 1, sizeof (command_line2), output2);
	pclose (output2);
} */

/*initialisation du timer de lecture des sockets*/
timer = new QTimer(this);
connect( timer, SIGNAL(timeout()), this, SLOT(Checksmbpopup()));
timer->start(1000, FALSE );
UpdateLed();
slotStatusMsg();
}

KTuxPop::~KTuxPop()
{
pthread_cancel (scanner);
pthread_cancel (scan_alias);
}

void KTuxPop::initKeyAccel()
{
  keyAccel = new KAccel(this);
	keyAccel->insertItem ("Reply", "Reply","CTRL+R");
	keyAccel->insertItem ("Delete", "Delete","CTRL+D");
	keyAccel->insertItem ("Next", "Next","CTRL+N");
	keyAccel->insertItem ("Previous", "Previous","CTRL+P");
	keyAccel->insertItem ("Options", "Options","CTRL+O");
	keyAccel->insertItem ("Ip", "Ip","CTRL+I");
  keyAccel->connectItem(KAccel::New, this, SLOT(slotFileNew()));
  keyAccel->connectItem("Reply", this, SLOT(slotFileReply()));
  keyAccel->connectItem("Delete", this, SLOT(slotFileDelete()));
  keyAccel->connectItem("Next", this, SLOT(slotFileSuivant()));
  keyAccel->connectItem("Previous", this, SLOT(slotFilePrecedent()));
  keyAccel->connectItem("Options", this, SLOT(slotEditOptions()));
  keyAccel->connectItem("Ip", this, SLOT(slotShowIp()));
  keyAccel->connectItem(KAccel::Quit, this, SLOT(slotFileQuit()));
  keyAccel->connectItem(KAccel::Copy, this, SLOT(slotEditCopy()));
  keyAccel->connectItem(KAccel::Help, kapp, SLOT(appHelpActivated()));
  keyAccel->changeMenuAccel(fileMenu, ID_FILE_NEW, KAccel::New);
  keyAccel->changeMenuAccel(fileMenu, ID_FILE_REPLY, "Reply");
  keyAccel->changeMenuAccel(fileMenu, ID_FILE_DELETE, "Delete");
  keyAccel->changeMenuAccel(fileMenu, ID_FILE_SUIVANT, "Next");
  keyAccel->changeMenuAccel(fileMenu, ID_FILE_PRECEDENT, "Previous");
  keyAccel->changeMenuAccel(editMenu, ID_EDIT_OPTIONS, "Options");
  keyAccel->changeMenuAccel(fileMenu, ID_FILE_QUIT, KAccel::Quit);
  keyAccel->readSettings();	
}

void KTuxPop::initMenuBar()
{
  fileMenu = new QPopupMenu();
  fileMenu->insertItem(Icon("filemail.xpm"), i18n("&New Message"), ID_FILE_NEW);
	fileMenu->insertItem(Icon("send.xpm"), i18n("&Reply"), ID_FILE_REPLY);
	fileMenu->insertItem(Icon("delete.xpm"), i18n("&Delete"), ID_FILE_DELETE);
  fileMenu->insertSeparator();
	fileMenu->insertItem(Icon("back.xpm"), i18n("&Previous"), ID_FILE_PRECEDENT);
	fileMenu->insertItem(Icon("forward.xpm"), i18n("&Next"), ID_FILE_SUIVANT);
  fileMenu->insertSeparator();
  fileMenu->insertItem(i18n("&Quit"), ID_FILE_QUIT);
  editMenu = new QPopupMenu();
  editMenu->insertItem(i18n("Options"), ID_EDIT_OPTIONS);
  editMenu->insertItem(i18n("Configuration"), ID_EDIT_CONFIG);
  QString aboutstring=kapp->appName()+" "+VERSION+"\n\nDeveloped by MikMak\nE-Mail : MikMak@users.sourceforge.net\n\nThis program is published under the terms of the GNU General Public License";
  helpMenu = new QPopupMenu();
  helpMenu = kapp->getHelpMenu(true, aboutstring);
  menuBar()->insertItem(i18n("&Messages"), fileMenu);
  menuBar()->insertItem(i18n("&Edit"), editMenu);
  menuBar()->insertSeparator();
  menuBar()->insertItem(i18n("&Help"), helpMenu);
  connect(fileMenu, SIGNAL(activated(int)), SLOT(commandCallback(int)));
  connect(editMenu, SIGNAL(activated(int)), SLOT(commandCallback(int)));
}

void KTuxPop::initToolBar()
{
  toolBar()->insertButton(Icon("filemail.xpm"), ID_FILE_NEW, true, i18n("New Message"));
  toolBar()->insertButton(Icon("send.xpm"), ID_FILE_REPLY, true, i18n("Reply"));
  toolBar()->insertButton(Icon("delete.xpm"), ID_FILE_DELETE, true, i18n("Delete"));
	toolBar()->insertSeparator();
	toolBar()->insertButton(Icon("back.xpm"), ID_FILE_PRECEDENT, true, i18n("Previous Message"));	
	toolBar()->insertButton(Icon("forward.xpm"), ID_FILE_SUIVANT, true, i18n("Next Message"));		
  toolBar()->insertSeparator();
if (filtre_actif)  toolBar()->insertButton(Icon(appdir+"/pics/aim.xpm"), ID_OPTION_FILTRE, true, i18n("Enable/Disable filters"));
else toolBar()->insertButton(Icon(appdir+"/pics/aimno.xpm"), ID_OPTION_FILTRE, true, i18n("Enable/Disable filters"));
  toolBar()->insertButton(Icon(appdir+"/pics/rebuildno.xpm"), ID_OPTION_REPLYER, true, i18n("Enable/Disable the autoreply"));
if (beeper)  toolBar()->insertButton(Icon(appdir+"/pics/playsound.xpm"), ID_OPTION_BEEP, true, i18n("Enable/Disable the beeper"));
else toolBar()->insertButton(Icon(appdir+"/pics/playsoundno.xpm"), ID_OPTION_BEEP, true, i18n("Enable/Disable the beeper"));
  toolBar()->insertSeparator();

  connect(toolBar(), SIGNAL(clicked(int)), SLOT(commandCallback(int)));
}

void KTuxPop::initStatusBar()
{
	Myled = new KLed(KLed::blue,KLed::On, KLed::sunken, statusBar(),"maled");
  statusBar()->insertItem(i18n(IDS_STATUS_DEFAULT), ID_STATUS_MSG);
	statusBar()->insertItem(i18n("xx"), ID_STATUS_SPACE);
	statusBar()->changeItem("", ID_STATUS_SPACE);
	statusBar()->insertWidget(Myled,150, ID_STATUS_NEW);
	statusBar()->insertItem(i18n("x"), ID_STATUS_SPACE2);
	statusBar()->changeItem("", ID_STATUS_SPACE2);
	statusBar()->setInsertOrder(KStatusBar::RightToLeft);
}

void KTuxPop::initTabs(){
fromlabel = new QLabel(i18n("From:"),this,0,0);
fromlabel->setGeometry(3,50,30,20);
sender = new QMultiLineEdit(this,0);
sender->setReadOnly(true);
sender->setGeometry (35,50,125,20);
tolabel = new QLabel(i18n("To:"),this,0,0);
tolabel->setGeometry(165,50,175,20);
to = new QMultiLineEdit(this,0);
to->setGeometry (185,50,205,20);
to->setReadOnly(true);
maintab = new CTabCtl(this,"maintab","normal");
w1 = new QWidget(maintab,"page1");
w2 = new QWidget(maintab,"page2");
w3 = new QWidget(maintab,"page3");
Logo = new QPixmap(appdir + "/pics/logo.gif");
w1->setBackgroundPixmap(*Logo);
w2->setBackgroundPixmap(*Logo);
w3->setBackgroundPixmap(*Logo);
prive = new QMultiLineEdit(w1,"prive");
prive->setReadOnly(true);
groupe = new QMultiLineEdit(w2,"groupe");
groupe->setReadOnly(true);
autres = new QMultiLineEdit(w3,"all");
autres->setReadOnly(true);
maintab->setGeometry(0,75,400,300);
prive->resize(395,275);
groupe->resize(395,275);
autres->resize(395,275);
w1->resize(400,275);
w2->resize(400,275);
w3->resize(400,275);
maintab->addTab(w1,i18n("&Privates"));
maintab->addTab(w2,i18n("&Groups"));
maintab->addTab(w3,i18n("&Others"));
connect(maintab, SIGNAL(tabSelected(int)),SLOT(tabselected(int)));
}

void KTuxPop::initSockets(){
enhancedperms();
socket_perso = socket (AF_INET, SOCK_DGRAM, IPPROTO_UDP);
if (socket_perso<0){
	KMsgBox::message(0,"Socket problem : socket_perso","KTuxPop cannot open the socket",0,0);
	exit(1);	
}
socket_broadcast = socket (AF_INET, SOCK_DGRAM, IPPROTO_UDP);
if (socket_broadcast<0){
	KMsgBox::message(0,"Socket problem : socket_broadcast","KTuxPop cannot open the socket",0,0);
	exit(1);	
}

if (fcntl (socket_broadcast, F_SETFL, O_NONBLOCK)<0) {
	KMsgBox::message(0,"Socket problem : socket_broadcast","KTuxPop cannot establish the socket in non blocking mode",0,0);
	exit(1);
}

if (fcntl (socket_perso, F_SETFL, O_NONBLOCK)<0) {
	KMsgBox::message(0,"Socket problem : socket_perso","KTuxPop cannot establish the socket in non blocking mode",0,0);
	exit(1);
}

int on=1;
sin_broadcast.sin_family=AF_INET;
sin_broadcast.sin_port=htons(138);
sin_broadcast.sin_addr.s_addr = inet_addr((const char*)BROAD_ADDR);
setsockopt (socket_broadcast, SOL_SOCKET, SO_REUSEADDR, &on, sizeof(on));

if (bind (socket_broadcast, (struct sockaddr *) &sin_broadcast, sizeof(sin_broadcast))<0){
		KMsgBox::message(0,"Socket problem : socket_broadcast","KTuxPop cannot bind the socket",0,0);
		exit(1);
}

sin_perso.sin_family=AF_INET;
sin_perso.sin_port=htons(138);
sin_perso.sin_addr.s_addr = inet_addr((const char*)MYIP);
setsockopt (socket_perso, SOL_SOCKET, SO_REUSEADDR, &on, sizeof(on));

if (bind (socket_perso, (struct sockaddr *) &sin_perso, sizeof(sin_perso))<0){
		KMsgBox::message(0,"Socket problem : socket_perso","KTuxPop cannot bind the socket",0,0);
		exit(1);
}

socket_salup_entree_broad = socket (AF_INET, SOCK_DGRAM, IPPROTO_UDP);
if (socket_salup_entree_broad<0){
	KMsgBox::message(0,"Socket problem : socket_salup_entree_broad","KTuxPop cannot open the socket",0,0);
	exit(1);	
}
socket_salup_entree_perso = socket (AF_INET, SOCK_DGRAM, IPPROTO_UDP);
if (socket_salup_entree_perso<0){
	KMsgBox::message(0,"Socket problem : socket_salup_entree_perso","KTuxPop cannot open the socket",0,0);
	exit(1);	
}
if (fcntl (socket_salup_entree_broad, F_SETFL, O_NONBLOCK)<0) {
	KMsgBox::message(0,"Socket problem : socket_salup_entree_broad","KTuxPop cannot establish the socket in non-blocking mode",0,0);
	exit(1);
}
if (fcntl (socket_salup_entree_perso, F_SETFL, O_NONBLOCK)<0) {
	KMsgBox::message(0,"Socket problem : socket_salup_entree_perso","KTuxPop cannot establish the socket in non-blocking mode",0,0);
	exit(1);
}

sin_entree_broad.sin_family=AF_INET;
sin_entree_broad.sin_port=htons(9279);
sin_entree_broad.sin_addr.s_addr = INADDR_BROADCAST;

if (bind (socket_salup_entree_broad, (struct sockaddr *) &sin_entree_broad, sizeof(sin_entree_broad))<0){
		KMsgBox::message(0,"Socket problem : socket_salup_entree_broad","KTuxPop cannot bind the socket",0,0);
		exit(1);
}

sin_entree_perso.sin_family=AF_INET;
sin_entree_perso.sin_port=htons(9279);
sin_entree_perso.sin_addr.s_addr = inet_addr((const char*)MYIP);

if (bind (socket_salup_entree_perso, (struct sockaddr *) &sin_entree_perso, sizeof(sin_entree_perso))<0){
		KMsgBox::message(0,"Socket problem : socket_salup_entree_perso","KTuxPop cannot bind the socket",0,0);
		exit(1);
}

QSocketNotifier *sn_perso;
sn_perso = new QSocketNotifier( socket_perso, QSocketNotifier::Read, this );
connect( sn_perso, SIGNAL(activated(int)),this, SLOT(Checkpopup(int)) );
QSocketNotifier *sn_broadcast;
sn_broadcast = new QSocketNotifier( socket_broadcast, QSocketNotifier::Read, this );
connect( sn_broadcast, SIGNAL(activated(int)),this, SLOT(Checkpopup(int)) );

QSocketNotifier *salup_perso;
QSocketNotifier *salup_broadcast;

salup_perso = new QSocketNotifier( socket_salup_entree_perso, QSocketNotifier::Read,this);
salup_broadcast = new QSocketNotifier( socket_salup_entree_broad, QSocketNotifier::Read,this);

connect( salup_perso, SIGNAL(activated(int)),this, SLOT(CheckSalup(int)));
connect( salup_broadcast, SIGNAL(activated(int)),this, SLOT(CheckSalup(int)));
normalperms();
}

void KTuxPop::enableCommand(int id_)
{
  menuBar()->setItemEnabled(id_, true);
  toolBar()->setItemEnabled(id_, true);
}

void KTuxPop::disableCommand(int id_)
{
  menuBar()->setItemEnabled(id_, false);
  toolBar()->setItemEnabled(id_, false);
}

void KTuxPop::saveOptions()
{	
config->setGroup("General");
config->writeEntry("Install",false);
config->writeEntry("Beeper",beeper);
config->writeEntry("Restaurer",restaurer);
config->writeEntry("Loguer",loguer);
config->writeEntry("Logo",showlogo);
config->writeEntry("Alias",my_alias);
config->writeEntry("Repondeur",messages_repondeur);
config->writeEntry("Workgroup",workgroup);
config->writeEntry("Hostname",hostname);
config->writeEntry("Broadcast",BROAD_ADDR);
config->writeEntry("Favoris",favoris);
config->setGroup("Filtres");
config->writeEntry("Filtres actifs",filtre_actif);
config->writeEntry("Filtrer all",filtrer_all);
config->writeEntry("Filtrer groupe",filtrer_groupe);
config->writeEntry("Filtrer persos",filtrer_persos);
config->writeEntry("Liste_filtre",filtre_perso);
config->setGroup("Popups");
config->writeEntry("persos_mess",recus->persos_mess);
config->writeEntry("groupe_mess",recus->groupe_mess);
config->writeEntry("autres_mess",recus->autres_mess);
config->writeEntry("persos_orig",recus->persos_orig);
config->writeEntry("groupe_orig",recus->groupe_orig);
config->writeEntry("autres_orig",recus->autres_orig);
config->writeEntry("persos_dest",recus->persos_dest);
config->writeEntry("groupe_dest",recus->groupe_dest);
config->writeEntry("autres_dest",recus->autres_dest);
config->writeEntry("new_persos",recus->new_persos);
config->writeEntry("new_groupe",recus->new_groupe);
config->writeEntry("new_autres",recus->new_autres);
config->writeEntry("ip_persos",recus->ip_persos);
config->writeEntry("ip_groupe",recus->ip_groupe);
config->writeEntry("ip_autres",recus->ip_autres);
config->writeEntry("nombre_popups_total",recus->nombre_popups_total);
config->writeEntry("nombre_popups_persos",recus->nombre_popups_persos);
config->writeEntry("nombre_popups_groupe",recus->nombre_popups_groupe);
config->writeEntry("nombre_popups_autres",recus->nombre_popups_autres);
config->writeEntry("courant_perso",recus->courant_perso);
config->writeEntry("courant_groupe",recus->courant_groupe);
config->writeEntry("courant_autres",recus->courant_autres);
}

void KTuxPop::readOptions()
{
config->setGroup("General");
beeper = config->readBoolEntry("Beeper",true);
restaurer = config->readNumEntry("Restaurer",0);
loguer = config->readBoolEntry("Loguer",true);
showlogo = config->readBoolEntry("Logo",showlogo);
config->readListEntry ("Alias", my_alias);
config->readListEntry ("Repondeur", messages_repondeur);
config->readListEntry ("Favoris" , favoris);
config->setGroup("Filtres");
filtre_actif = config->readBoolEntry("Filtres actifs",false);
filtrer_all = config->readBoolEntry("Filtrer all",false);
filtrer_groupe = config->readBoolEntry("Filtrer groupe",false);
filtrer_persos = config->readBoolEntry("Filtrer persos",false);
config->readListEntry ("Liste_filtre" , filtre_perso);
config->setGroup("Popups");
config->readListEntry("persos_mess",recus->persos_mess);
config->readListEntry("groupe_mess",recus->groupe_mess);
config->readListEntry("autres_mess",recus->autres_mess);
config->readListEntry("persos_orig",recus->persos_orig);
config->readListEntry("groupe_orig",recus->groupe_orig);
config->readListEntry("autres_orig",recus->autres_orig);
config->readListEntry("persos_dest",recus->persos_dest);
config->readListEntry("groupe_dest",recus->groupe_dest);
config->readListEntry("autres_dest",recus->autres_dest);
config->readListEntry("new_persos",recus->new_persos);
config->readListEntry("new_groupe",recus->new_groupe);
config->readListEntry("new_autres",recus->new_autres);
config->readListEntry("ip_persos",recus->ip_persos);
config->readListEntry("ip_groupe",recus->ip_groupe);
config->readListEntry("ip_autres",recus->ip_autres);
recus->nombre_popups_total=config->readNumEntry("nombre_popups_total",0);
recus->nombre_popups_persos=config->readNumEntry("nombre_popups_persos",0);
recus->nombre_popups_groupe=config->readNumEntry("nombre_popups_groupe",0);
recus->nombre_popups_autres=config->readNumEntry("nombre_popups_autres",0);
recus->courant_perso=config->readNumEntry("courant_perso",0);
recus->courant_groupe=config->readNumEntry("courant_groupe",0);
recus->courant_autres=config->readNumEntry("courant_autres",0);
unsigned int i;
for (i=0 ; i < my_alias.count() ; i++){
existing_alias.append(my_alias.at(i));
existing_alias.append(hostname.lower());
}
}

bool KTuxPop::queryExit()
{
	popup->Send_byebye_Salup();
  saveOptions();
  return true;
}

void KTuxPop::slotFileNew()
{
UnsetNew();
UpdateLed();
send = new envoi_dialog(this, "envoi",false);
send->show();
}

void KTuxPop::slotFileQuit()
{
	queryExit();
	recus->~Reception();
	close (socket_perso);
	close (socket_broadcast);
	close (socket_salup_entree_broad);
	close (socket_salup_entree_perso);
	kapp->quit();
}

void KTuxPop::slotEditCopy()
{
}

void KTuxPop::slotShowIp(){
switch (maintab->getCurrentTab()){
case 0:
KMsgBox::message(0,"IP Source", recus->ip_persos.at(recus->courant_perso));
break;
case 1:
KMsgBox::message (0,"IP Source", recus->ip_groupe.at(recus->courant_groupe));
break;
case 2:
KMsgBox::message (0,"IP Source", recus->ip_autres.at(recus->courant_autres));
break;
}
}

void KTuxPop::slotEditOptions(){
QStrList before_changes;
QStrList after_changes;
before_changes=my_alias;
Options_dialog = new Options (this,"options");
Options_dialog->show();
if (!showlogo) UnsetLogo();
else if (!recus->nombre_popups_total) SetLogo();
after_changes=my_alias;
my_alias = before_changes;
popup->Send_byebye_Salup();
my_alias=after_changes;
saveOptions();
QString dst("*");
popup->Send_Salup_Alias(dst,BROAD_ADDR);
if (filtre_actif) toolBar()->setButtonPixmap ( ID_OPTION_FILTRE,Icon(appdir+"/pics/aim.xpm"));
else toolBar()->setButtonPixmap ( ID_OPTION_FILTRE,Icon(appdir+"/pics/aimno.xpm"));
if (replyer) toolBar()->setButtonPixmap ( ID_OPTION_REPLYER,Icon(appdir+"/pics/rebuild.xpm"));
else toolBar()->setButtonPixmap ( ID_OPTION_REPLYER,Icon(appdir+"/pics/rebuildno.xpm"));
if (beeper) toolBar()->setButtonPixmap ( ID_OPTION_BEEP,Icon(appdir+"/pics/playsound.xpm"));
else toolBar()->setButtonPixmap ( ID_OPTION_BEEP,Icon(appdir+"/pics/playsoundno.xpm"));
}

void KTuxPop::slotFileReply(){
UnsetNew();
UpdateLed();
switch (maintab->getCurrentTab()){
case 0:
if (recus->nombre_popups_persos){
send = new envoi_dialog(this, "envoi",true,recus->persos_orig.at(recus->courant_perso),make_header(0));
send->show();
}
break;
case 1:
if (recus->nombre_popups_groupe){
send = new envoi_dialog(this, "envoi",true,recus->groupe_orig.at(recus->courant_groupe),make_header(1));
send->show();
}
break;
case 2:
if (recus->nombre_popups_autres){
send = new envoi_dialog(this, "envoi",true,recus->autres_orig.at(recus->courant_autres),make_header(2));
send->show();
}
break;
}

}

void KTuxPop::slotFileDelete(){
switch (maintab->getCurrentTab()){
case 0:
if (recus->nombre_popups_persos) recus->Del_popup (recus->courant_perso,0);
if (recus->nombre_popups_persos){
ShowText(recus->persos_mess.at(recus->courant_perso),0);
sender->setText(recus->persos_orig.at(recus->courant_perso));
to->setText(recus->persos_dest.at(recus->courant_perso));
}
if (!recus->nombre_popups_persos){
	prive->clear();
	sender->clear();
	to->clear();
	UnsetNew();
}
if (!recus->nombre_popups_persos && recus->nombre_popups_groupe) maintab->setCurrentTab(1);
else if (!recus->nombre_popups_persos && recus->nombre_popups_autres) maintab->setCurrentTab(2);
break;
case 1:
if (recus->nombre_popups_groupe) recus->Del_popup (recus->courant_groupe,1);
if (recus->nombre_popups_groupe){
ShowText(recus->groupe_mess.at(recus->courant_groupe),1);
sender->setText(recus->groupe_orig.at(recus->courant_groupe));
to->setText(recus->groupe_dest.at(recus->courant_groupe));
}
if (!recus->nombre_popups_groupe){
	groupe->clear();
	sender->clear();
	to->clear();
	UnsetNew();
}
if (!recus->nombre_popups_groupe && recus->nombre_popups_persos) maintab->setCurrentTab(0);
else if (!recus->nombre_popups_groupe && recus->nombre_popups_autres) maintab->setCurrentTab(2);
break;
case 2:
if (recus->nombre_popups_autres) recus->Del_popup (recus->courant_autres,2);
if (recus->nombre_popups_autres){
ShowText(recus->autres_mess.at(recus->courant_autres),2);
sender->setText(recus->autres_orig.at(recus->courant_autres));
to->setText(recus->autres_dest.at(recus->courant_autres));
}
if (!recus->nombre_popups_autres) {
	autres->clear();
	sender->clear();
	to->clear();
	UnsetNew();
}
if (!recus->nombre_popups_autres && recus->nombre_popups_persos) maintab->setCurrentTab(0);
else if (!recus->nombre_popups_autres && recus->nombre_popups_groupe) maintab->setCurrentTab(1);
break;
}
UpdateLed();
if (!recus->nombre_popups_total && showlogo) SetLogo();
slotStatusMsg();
}

void KTuxPop::slotFilePrecedent(){
UnsetNew();
switch (maintab->getCurrentTab()){
case 0:
if (recus->nombre_popups_persos){
if (recus->courant_perso) recus->courant_perso -= 1;
ShowText(recus->persos_mess.at(recus->courant_perso),0);
sender->setText(recus->persos_orig.at(recus->courant_perso));
to->setText(recus->persos_dest.at(recus->courant_perso));
}
break;
case 1:
if (recus->nombre_popups_groupe){
if (recus->courant_groupe) recus->courant_groupe -= 1;
ShowText(recus->groupe_mess.at(recus->courant_groupe),1);
sender->setText(recus->groupe_orig.at(recus->courant_groupe));
to->setText(recus->groupe_dest.at(recus->courant_groupe));
}
break;
case 2:
if (recus->nombre_popups_autres){
if (recus->courant_autres) recus->courant_autres -= 1;
ShowText(recus->autres_mess.at(recus->courant_autres),2);
sender->setText(recus->autres_orig.at(recus->courant_autres));
to->setText(recus->autres_dest.at(recus->courant_autres));
}
break;
}
UpdateLed();
slotStatusMsg();
}

void KTuxPop::slotFileSuivant(){
UnsetNew();
switch (maintab->getCurrentTab()){
case 0:
if (recus->courant_perso != recus->nombre_popups_persos - 1){
recus->courant_perso += 1;
ShowText(recus->persos_mess.at(recus->courant_perso),0);
sender->setText(recus->persos_orig.at(recus->courant_perso));
to->setText(recus->persos_dest.at(recus->courant_perso));
}
break;
case 1:
if (recus->courant_groupe != recus->nombre_popups_groupe - 1){
recus->courant_groupe += 1;
ShowText(recus->groupe_mess.at(recus->courant_groupe),1);
sender->setText(recus->groupe_orig.at(recus->courant_groupe));
to->setText(recus->groupe_dest.at(recus->courant_groupe));
}
break;
case 2:
if (recus->courant_autres != recus->nombre_popups_autres - 1){
recus->courant_autres += 1;
ShowText(recus->autres_mess.at(recus->courant_autres),2);
sender->setText(recus->autres_orig.at(recus->courant_autres));
to->setText(recus->autres_dest.at(recus->courant_autres));
}
break;
}
UpdateLed();
slotStatusMsg();
}

void KTuxPop::slotStatusMsg()
{
switch (maintab->getCurrentTab()){
case 0:
if (recus->nombre_popups_persos) status.sprintf(i18n("Message %i on %i"),recus->courant_perso + 1,recus->nombre_popups_persos);
else status.sprintf(i18n("Message %i on %i"),0,recus->nombre_popups_persos);
break;
case 1:
if (recus->nombre_popups_groupe) status.sprintf(i18n("Message %i on %i"),recus->courant_groupe + 1,recus->nombre_popups_groupe);
else status.sprintf(i18n("Message %i on %i"),0,recus->nombre_popups_groupe);
break;
case 2:
if (recus->nombre_popups_autres) status.sprintf(i18n("Message %i on %i"),recus->courant_autres + 1,recus->nombre_popups_autres);
else status.sprintf(i18n("Message %i on %i"),0,recus->nombre_popups_autres);
break;
}
statusBar()->clear();
statusBar()->changeItem(status, ID_STATUS_MSG);

/*barre de titres*/
if (recus->nombre_popups_total==1) status.sprintf("%i message",recus->nombre_popups_total);
else if (recus->nombre_popups_total > 1) status.sprintf("%i messages",recus->nombre_popups_total);
else status = "KTuxPop 1.2";
setCaption (status);
}

void KTuxPop::commandCallback(int id_)
{
  switch (id_)
  {
    case ID_FILE_NEW:
    	 	 slotFileNew();
         break;
		case ID_FILE_REPLY:
    	 	 slotFileReply();
         break;
		case ID_FILE_DELETE:
    	 	 slotFileDelete();
         break;
		case ID_FILE_PRECEDENT:
    	 	 slotFilePrecedent();
         break;
		case ID_FILE_SUIVANT:
    	 	 slotFileSuivant();
         break;
    case ID_FILE_QUIT:
         slotFileQuit();
         break;
    case ID_EDIT_COPY:
         slotEditCopy();
         break;
    case ID_EDIT_OPTIONS:
         slotEditOptions();
         break;
    case ID_OPTION_FILTRE:
         slotOptionFiltre();
         break;
    case ID_OPTION_REPLYER:
         slotOptionReplyer();
         break;
    case ID_OPTION_BEEP:
         slotOptionBeep();
         break;
    case ID_EDIT_CONFIG:
         showStartupConfig();
         break;
    default:
         break;
  }
}

void KTuxPop::Checkpopup(int sock){
char recvbuffer[1000];
struct sockaddr_in from;
unsigned int fromlen = sizeof(from);
int i;
char *orig;
char *dest;
char *mess;
unsigned int repere=0;
int typ = 0;
char timebuf[10];
struct tm *timeptr;
time_t nw;
nw = time((time_t *)NULL);
timeptr= localtime(&nw);
strftime (timebuf, sizeof(timebuf), "%X\n",timeptr);

memset (recvbuffer, 0,sizeof(recvbuffer));

i=recvfrom(sock, recvbuffer, sizeof(recvbuffer),0,(struct sockaddr *)&from, &fromlen);

if (i!=-1){
	if (recvbuffer[161]=='M' && recvbuffer[162]=='E' && recvbuffer[163]=='S' && recvbuffer[164]=='S' && recvbuffer[165]=='N' && recvbuffer[166]=='G' && recvbuffer[167]=='R')
		repere=170;

if (repere != 0){
QString ip_tmp;
ip_tmp.sprintf("IP source : %s\nPort source : %i",inet_ntoa(from.sin_addr),ntohs(from.sin_port));

orig = &recvbuffer[repere];
dest = &orig[strlen(orig)+1];
mess = &dest[strlen(dest)+1];
QString origine (orig);
origine = origine.upper();
QString destination (dest);
destination = destination.upper();
QString message(mess);

if (destination.contains(all,false) || destination.contains(etoile,false) || destination.contains(toutlemonde,false) || destination.contains(touslesgens,false) || destination.contains(allpopup,false)) typ = 3;
if (destination==workgroup || destination==grpe2 || destination.contains(group1,false) || destination.contains(group2,false) || destination.contains(group3,false) || destination.contains(group4,false)) typ = 2;
if (destination==hostname || destination==hostname2 || destination.contains(perso1,false) || destination.contains(perso2,false) || destination.contains(perso3,false) || destination.contains(perso4,false)) typ = 1;

if (CheckFiltre(message, origine, destination, typ)){
	QString message_final (timebuf);
	message_final += mess;
	recus->Add_popup(message_final, origine, destination, ip_tmp, typ);
	if (showlogo)	UnsetLogo();
	sender->setText(origine);
	to->setText(destination);
	ShowText (message_final, typ - 1);
	maintab->setCurrentTab(typ - 1);
	if (beeper) kapp->beep();
	if ((restaurer == 1 && typ == 1) || restaurer == 2 ) this->show();
	dest_precedent = destination;
	orig_precedent = origine;
	mess_precedent = message;
	if (replyer && typ == 1 )
		{
		QString repond(i18n("AutoReply"));
		repond += " :\r\n";
		repond += messages_repondeur.current();
		popup->new_popup(false,origine,hostname,origine,repond);
		}
	UpdateLed();
	slotStatusMsg();
}
}
}
}


void KTuxPop::Checksmbpopup(){
timer->stop();
if (timer_browse.elapsed() > 600000 || starting)  //1200000
	{
	starting=false;
	enhancedperms();
	if (pthread_create(&scanner, NULL, scan_people, NULL)<0){
		KMsgBox::message (0,"threading problem","create thread",0,0);
		exit (1);
	}
	normalperms();
}

Popup_Alias_Received();
FILE *file_mes;
char mess[1000];

file_mes = fopen(appdir+"/ktuxpop.msg", "r");
while (fread (mess, 1, 1000, file_mes)!=0){

	char *orig;
	char *dest;
	char *msg;

	orig = &mess[0];
	dest = &orig[strlen(orig)+1];
	msg = &dest[strlen(dest)+1];
	QString origine (orig);
	origine = origine.upper();
	QString destination (dest);
	destination = destination.upper();
	QString message (msg);
	
int typ=0;
if (destination==hostname || destination==hostname2 || destination.contains(perso1,false) || destination.contains(perso2,false) || destination.contains(perso3,false) || destination.contains(perso4,false)) typ = 1;
if (CheckFiltre(message, origine,destination, 1)){
	recus->Add_popup(message, origine, destination,"Sorry, message received by Samba\nCannot find the source IP",1);
	sender->setText(origine);
	to->setText(destination);
	ShowText(message,0);
	if (showlogo)	UnsetLogo();
	if (beeper) kapp->beep();
	if ((restaurer == 1 && typ == 1) || restaurer == 2 ) this->show();
	maintab->setCurrentTab(0);
	mess_precedent = message;
	dest_precedent = destination;
	orig_precedent = origine;
	if (replyer)
		{
		QString repond(i18n("AutoReply"));
		repond += " :\r\n";
		repond += messages_repondeur.current();
		popup->new_popup(false,origine,hostname,origine,repond);
		}
UpdateLed();
slotStatusMsg();
}
}
fclose (file_mes);
enhancedperms();
file_mes = fopen (appdir+"/ktuxpop.msg", "w");
fclose (file_mes);
normalperms();
timer->start(1000, FALSE );
}

void KTuxPop::tabselected(int id){
char *orig = NULL;
char *dest = NULL;
char *mess = NULL;
switch(id){
case 0:
if (recus->nombre_popups_persos){
orig = recus->persos_orig.at(recus->courant_perso);
dest = recus->persos_dest.at(recus->courant_perso);
mess = recus->persos_mess.at(recus->courant_perso);
}
break;
case 1:
if (recus->nombre_popups_groupe){
orig = recus->groupe_orig.at(recus->courant_groupe);
dest = recus->groupe_dest.at(recus->courant_groupe);
mess = recus->groupe_mess.at(recus->courant_groupe);
}
break;
case 2:
if (recus->nombre_popups_autres){
orig = recus->autres_orig.at(recus->courant_autres);
dest = recus->autres_dest.at(recus->courant_autres);
mess = recus->autres_mess.at(recus->courant_autres);
}
break;
}
ShowText(mess,id);
sender->setText(orig);
to->setText(dest);
UpdateLed();
slotStatusMsg();
}

void KTuxPop::UnsetNew(){
switch (maintab->getCurrentTab()){
case 0:
if (recus->nombre_popups_persos){
recus->new_persos.remove(recus->courant_perso);
recus->new_persos.insert(recus->courant_perso,"false");
}
break;
case 1:
if (recus->nombre_popups_groupe){
recus->new_groupe.remove(recus->courant_groupe);
recus->new_groupe.insert(recus->courant_groupe,"false");
}
break;
case 2:
if (recus->nombre_popups_autres){
recus->new_autres.remove(recus->courant_autres);
recus->new_autres.insert(recus->courant_autres,"false");
}
break;
}
Myled->setColor(KLed::blue);
}

void KTuxPop::UpdateLed(){
char *courant = NULL;
switch (maintab->getCurrentTab()){
case 0:
courant = recus->new_persos.at(recus->courant_perso); 	
break;
case 1:
courant = recus->new_groupe.at(recus->courant_groupe); 	
break;
case 2:
courant = recus->new_autres.at(recus->courant_autres);
break;
}
if (strlen(courant) == 4) Myled->setColor(KLed::red);
else Myled->setColor(KLed::blue);

}

void KTuxPop::SetLogo(){
prive->hide();
groupe->hide();
autres->hide();
}

void KTuxPop::UnsetLogo(){
prive->show();
groupe->show();
autres->show();
}

bool KTuxPop::CheckFiltre(QString m,QString o,QString d,int type){
switch (type) {
case 0:
return false;
break;
case 1:
if ((filtre_actif && (filtrer_persos || filtre_perso.contains(o))) || (m == mess_precedent && o == orig_precedent && d == dest_precedent))
	return false;
else return true;
break;
case 2:
if ((filtre_actif && (filtrer_groupe || filtre_perso.contains(o))) || (m == mess_precedent && o == orig_precedent && d == dest_precedent))
	return false;
else return true;
break;
case 3:
if ((filtre_actif && (filtrer_all || filtre_perso.contains(o))) || (m == mess_precedent && o == orig_precedent && d == dest_precedent))
	return false;
else return true;
break;
}
}

QString KTuxPop::make_header(int id){
QString last_line;
QString head (i18n("Reply to "));
int num,i;

switch (id){
case 0:
num = prive->numLines();
last_line = prive->textLine(num-1);
for (i=num-1; strlen(last_line) <=1 && i != 1 ;i--)
{	last_line = prive->textLine(i-1);}
head = head + recus->persos_orig.at(recus->courant_perso) + " :\n" + last_line +"\n-------------------------------\n";
return head;
break;
case 1:
num = groupe->numLines();
last_line = groupe->textLine(num-1);
for (i=num-1; strlen(last_line) <=1 && i != 1 ;i--)
{	last_line = groupe->textLine(i-1);}
head = head + recus->groupe_orig.at(recus->courant_groupe) + " :\n" + last_line +"\n-------------------------------\n";
return head;
break;
case 2:
num = autres->numLines();
last_line = autres->textLine(num-1);
for (i=num-1; strlen(last_line) <=1 && i != 1 ;i--)
{	last_line = autres->textLine(i-1);}
head = head + recus->autres_orig.at(recus->courant_autres) + " :\n" + last_line +"\n-------------------------------\n";
return head;
break;
}
return head;
}
/** Adjusts the text to the size of the tab which prevents from having horizontal scrollbars on QMultiLineEdit */
void KTuxPop::ShowText(QString text, int Tab){
QString temp;
QString temp2;
QString temp3;
int i,sep;

switch (Tab){
case 0:
prive->clear();
sep = text.contains ('\n');
for ( i = 0; i <= sep ; i++) {
int f = text.find('\n');
temp = text;
if (f>=0)	temp.truncate (f);
prive->append(temp);
text = text.right(strlen(text) - text.find ('\n')-1);
while (prive->maxLineWidth()>387){
	while (prive->maxLineWidth()>387){
		temp2 = prive->textLine(prive->numLines()-1);
		temp3 = temp2.right(1) + temp3;
		temp2.truncate (strlen(temp2)-1);
		prive->removeLine(prive->numLines()-1);
		prive->append(temp2);
	}
prive->append(temp3);
temp3="";
}
}
recus->persos_mess.remove(recus->courant_perso);
recus->persos_mess.insert(recus->courant_perso, prive->text());
break;
case 1:
groupe->clear();
sep = text.contains ('\n');
for ( i = 0; i <= sep ; i++) {
int f = text.find('\n');
temp = text;
if (f>=0) temp.truncate (f);
groupe->append(temp);
text = text.right(strlen(text) - text.find ('\n')-1);
while (groupe->maxLineWidth()>387){
	while (groupe->maxLineWidth()>387){
		temp2 = groupe->textLine(groupe->numLines()-1);
		temp3 = temp2.right(1) + temp3;
		temp2.truncate (strlen(temp2)-1);
		groupe->removeLine(groupe->numLines()-1);
		groupe->append(temp2);
	}
groupe->append(temp3);
temp3="";
}
}
recus->groupe_mess.remove(recus->courant_groupe);
recus->groupe_mess.insert(recus->courant_groupe, groupe->text());
break;
case 2:
autres->clear();
sep = text.contains ('\n');
for ( i = 0; i <= sep ; i++) {
int f = text.find('\n');
temp = text;
if (f>=0)	temp.truncate (f);
autres->append(temp);
text = text.right(strlen(text) - text.find ('\n')-1);
while (autres->maxLineWidth()>387){
	while (autres->maxLineWidth()>387){
		temp2 = autres->textLine(autres->numLines()-1);
		temp3 = temp2.right(1) + temp3;
		temp2.truncate (strlen(temp2)-1);
		autres->removeLine(autres->numLines()-1);
		autres->append(temp2);
	}
autres->append(temp3);
temp3="";
}
}
recus->autres_mess.remove(recus->courant_autres);
recus->autres_mess.insert(recus->courant_autres, autres->text());
break;
}
}

void KTuxPop::CheckSalup(int sock){
unsigned char recvbuffer[500];
struct sockaddr_in from;
unsigned int fromlen = sizeof(from);
int i;
QString src_recu;
QString dst_recu;
QString alias_recu;
QString name_alias;

i = recvfrom(sock, recvbuffer, sizeof(recvbuffer),0,(struct sockaddr *)&from, &fromlen);

QString ip_tmp(inet_ntoa(from.sin_addr));

if (recvbuffer[0]==0x64)
{
	src_recu = QString ((const char *)recvbuffer+20);
	popup->Send_Salup_Alias (src_recu, ip_tmp);
#ifdef DBG
	printf("New people requering my aliases: %s\n",(const char *)src_recu);
#endif
}
else if (recvbuffer[0]==0xcb || recvbuffer[0]==0xcd)
{
	src_recu = QString ((const char*)recvbuffer+20);
	name_alias = src_recu.lower();
	dst_recu = QString ((const char*)recvbuffer+25+strlen(src_recu));
	alias_recu = QString ((const char*)recvbuffer+30+strlen(src_recu)+ strlen(dst_recu));
	alias_recu = alias_recu.upper();
	if (alias_recu != "TOUS LES GENS")
		{
		if (recvbuffer[0]==0xcb) record_alias(alias_recu, name_alias);
		else if (recvbuffer[0]==0xcd) delete_alias(alias_recu, name_alias);
		}
}
else if (recvbuffer[0]==0xc9)// || recvbuffer[0]==0xca)
{
	src_recu = QString ((const char*)recvbuffer+20);
	dst_recu = QString ((const char*)recvbuffer+25+strlen(src_recu));
	alias_recu = QString ((const char*)recvbuffer+30+strlen(src_recu)+ strlen(dst_recu));
	alias_recu = alias_recu.upper();
	if (liste_groupes.contains(alias_recu)==0) liste_groupes.append(alias_recu);
}
}

void KTuxPop::record_alias(QString alias, QString nom){
int idx = existing_alias.find(alias);
int idx_save = idx;
bool trouve = false;
if (idx!=-1)
	{
	idx++;
	QString t(existing_alias.at(idx));
	while (t != t.upper() && !t.isNull())
		{
		if (t == nom) trouve = true;
		idx++;
		t = existing_alias.at(idx);
		}
	if (!trouve)
		{
#ifdef DBG
		printf ("Adding alias in group: %s %s\n",(const char*)nom,(const char*)alias);
#endif
		existing_alias.insert (idx_save+1,nom);
		}
	}
else
	{
#ifdef DBG
	printf ("Adding alias in new group: %s %s\n",(const char*)nom,(const char*)alias);
#endif
	existing_alias.append (alias);
	existing_alias.append (nom);
	}
}

void KTuxPop::delete_alias (QString alias,QString nom){
int idx = existing_alias.find (alias);
if (idx!=-1)
	{
	idx++;
	QString t(existing_alias.at(idx));
	while (t != t.upper() && !t.isNull())
		{
		if (t == nom)
		{
#ifdef DBG
		printf ("Removing alias : %s\n",(const char*)existing_alias.at(idx));
#endif
		existing_alias.remove(idx);
		}
    idx++;
		t = existing_alias.at(idx);
		}
	/*vrifions que l'alias a d'autres membres, sinon on le dtruit de la liste*/
	idx = existing_alias.find (alias);
	t = existing_alias.at(idx+1);
	if (t == t.upper() || t.isEmpty()) existing_alias.remove(idx);
	}
}

void KTuxPop::slotOptionFiltre(){
filtre_actif = !filtre_actif;
if (filtre_actif) toolBar()->setButtonPixmap ( ID_OPTION_FILTRE,Icon(appdir+"/pics/aim.xpm"));
else toolBar()->setButtonPixmap ( ID_OPTION_FILTRE,Icon(appdir+"/pics/aimno.xpm"));
}

void KTuxPop::slotOptionReplyer(){
if (!replyer){
Repondeur *reponse_auto = new Repondeur();
reponse_auto->show();
}
else replyer = !replyer;
if (replyer) toolBar()->setButtonPixmap ( ID_OPTION_REPLYER,Icon(appdir+"/pics/rebuild.xpm"));
else toolBar()->setButtonPixmap ( ID_OPTION_REPLYER,Icon(appdir+"/pics/rebuildno.xpm"));
}

void KTuxPop::slotOptionBeep(){
beeper = !beeper;
if (beeper) toolBar()->setButtonPixmap ( ID_OPTION_BEEP,Icon(appdir+"/pics/playsound.xpm"));
else toolBar()->setButtonPixmap ( ID_OPTION_BEEP,Icon(appdir+"/pics/playsoundno.xpm"));
}

void KTuxPop::showStartupConfig(){
Workgrp *group_dialog = new Workgrp();
group_dialog->show();
saveOptions();
}

void *thread_alias(void *arg){
struct sockaddr_in sin_alias;
int socket_alias = socket (AF_INET, SOCK_STREAM, IPPROTO_TCP);
if (socket_alias<0){
	KMsgBox::message(0,"Socket problem : socket_alias","KTuxPop cannot open the socket",0,0);
	exit(1);	
}
sin_alias.sin_family=AF_INET;
sin_alias.sin_port=htons(9278);
sin_alias.sin_addr.s_addr =inet_addr((const char*)MYIP);

if ((bind (socket_alias, (struct sockaddr *) &sin_alias, sizeof(sin_alias))) < 0)
	{
	KMsgBox::message(0,"Socket problem : socket_alias","KTuxPop cannot bind the socket",0,0);
	exit(1);	
	}

if (listen(socket_alias,1)==-1){
#ifdef DBG
	printf ("%s\n",sys_errlist[errno]);
#endif
	KMsgBox::message(0,"Socket problem : socket_alias","KTuxPop cannot set the socket in  listen mode",0,0);
	exit(1);	
	}

int i,p;
char buff[1000];
char timebuf[10];
struct tm *timeptr;
time_t nw;
struct sockaddr_in fr;
unsigned int frlen = sizeof(fr);
pthread_setcancelstate(PTHREAD_CANCEL_ENABLE,NULL);
while (1) {
char *orig=NULL;
char *dest=NULL;
char *desti=NULL;
char *msg=NULL;
pthread_testcancel();
int socket_alias_accepted = accept(socket_alias, (struct sockaddr *) &fr,&frlen);
if (socket_alias_accepted!=-1) {
i = recvfrom (socket_alias_accepted, buff,sizeof(buff),0,(struct sockaddr *) &fr, &frlen);
QString ip_tmp;
ip_tmp.sprintf("IP source : %s\nPort source : %i",inet_ntoa(fr.sin_addr),ntohs(fr.sin_port));
if (buff[4] == 0x2c && buff[5] == 0x01){
orig = &buff[24];
dest = &orig[strlen(orig)+5];
desti = &dest[strlen(dest)+5];
QString origine (orig);
origine = origine.upper();
QString destination (desti);
destination = destination.upper();

for (p = 39 + strlen(orig) + strlen(desti) + strlen(dest); p < i && msg == NULL; p++) {
	if (buff[p] == 0 && buff[p+1] == 0 && buff[p+2] == 0)	msg = &buff[p+3];
}
nw = time((time_t *)NULL);
timeptr= localtime(&nw);
strftime (timebuf, sizeof(timebuf), "%X\n",timeptr);
QString message(timebuf);
message += msg;
DEST_ALIAS = destination;
ORIG_ALIAS = origine;
MSG_ALIAS = message;
IP_ALIAS = ip_tmp;
}
}
close (socket_alias_accepted);
}
}

void KTuxPop::Popup_Alias_Received(){
unsigned int j;
int typ=0;
QString destination(DEST_ALIAS);
QString origine (ORIG_ALIAS);
QString message (MSG_ALIAS);
QString ip_tmp (IP_ALIAS);
DEST_ALIAS="";
ORIG_ALIAS="";
MSG_ALIAS="";
IP_ALIAS="";
if (!destination.isEmpty() && !origine.isEmpty()){
QString alias1;
QString alias2=';';
for (j=0; j < my_alias.count() ; j++){
	alias1 = my_alias.at(j) + ';';
	alias2 += my_alias.at(j);
	if (destination.contains(alias1) || destination.contains(alias2) || destination == my_alias.at(j)) typ = 3;
}

if (destination.contains(all,false) || destination.contains(etoile,false) || destination.contains(toutlemonde,false) || destination.contains(touslesgens,false) || destination.contains(allpopup,false)) typ = 3;
if (destination==workgroup || destination==grpe2 || destination.contains(group1,false) || destination.contains(group2,false) || destination.contains(group3,false) || destination.contains(group4,false)) typ = 2;
if (destination==hostname || destination==hostname2 || destination.contains(perso1,false) || destination.contains(perso2,false) || destination.contains(perso3,false) || destination.contains(perso4,false)) typ = 1;

if (CheckFiltre(message, origine, destination, typ)){
	recus->Add_popup(message, origine, destination, ip_tmp, typ);
	sender->setText(origine);
	to->setText(destination);
	ShowText(message,typ-1);
	if (showlogo)	UnsetLogo();
	if (beeper) kapp->beep();
	if ((restaurer == 1 && typ == 1) || restaurer == 2 ) this->show();
	maintab->setCurrentTab(typ-1);
	mess_precedent = message;
	dest_precedent = destination;
	orig_precedent = origine;
}
UpdateLed();
slotStatusMsg();
}
}
