#include "kgraph.h"
#include "kgraph.moc"

KGraph::KGraph(QWidget *parent, const char *name)
	:QWidget(parent,name),online(FALSE)
{
    reset();
}

KGraph::~KGraph()
{

}

void KGraph::reset()
{

    int i;
    
    for (i = 0 ; i < NUMPOINTS; i++)
    {
	rcvfifo[i]=0;
	tmtfifo[i]=0;
    }
    rcvptr=0;
    tmtptr=0;
    online=FALSE;
}

void KGraph::graphon()
{
    online=TRUE;
}

void KGraph::addpoint(long rcv, long tmt)
{
    rcvfifo[rcvptr++]=(rcv/MAXDIFFERENCE*100);
    rcvptr%=NUMPOINTS;
    tmtfifo[tmtptr++]=tmt;
    tmtptr%=NUMPOINTS;

}

void KGraph::paintEvent( QPaintEvent *)
{
    QPainter paint(this);
    QString t1,t2,t3,t4,t5,u;
    QString temp;
    long    tmp;
    int x;
    
    t1.sprintf("B");
    t2.sprintf("y");
    t3.sprintf("t");
    t4.sprintf("e");
    t5.sprintf("s");
    u.sprintf("Time");
    paint.drawText(3,height()/2-45,t1);
    paint.drawText(3,height()/2-25,t2);
    paint.drawText(4,height()/2-3,t3);
    paint.drawText(3,height()/2+20,t4);
    paint.drawText(3,height()/2+40,t5);
    paint.drawText((width()/2)-15,height()-10,u);
    paint.drawLine(15,height()-23,width(),height()-23);
    paint.drawLine(15,0,15,height()-23);
    if (online)
    {
	for (x = 1 ; x<=NUMPOINTS ; x++ )
	{
		paint.setPen(red);
		paint.drawLine( 0+15 , 0 ,  (x-1) * ( x != NUMPOINTS ? ( width()/NUMPOINTS)+15 : (width()/NUMPOINTS)), rcvfifo[(rcvptr+x)%NUMPOINTS] );
//		paint.drawLine( (x-1) * ( x != NUMPOINTS ?
//				     ( width()/NUMPOINTS)+15 : (width()/NUMPOINTS) ) ,
//			   ( height()-25-rcvfifo[(rcvptr+x-1)%NUMPOINTS]),  /* Adjust for the grid offset and plot the point of the previous endpoint */
//			   x * width()/NUMPOINTS , 
//			   (height()-25-rcvfifo[(rcvptr+x)%NUMPOINTS]  ) ); /* 0 is at the top */ 
		tmp=rcvfifo[(rcvptr+x)%NUMPOINTS];
		tmp=(x-1) * ( x != NUMPOINTS ? ( width()/NUMPOINTS)+15 : (width()/NUMPOINTS) );
		paint.setPen(blue);
	    	paint.drawLine( (x-1) * ( x != NUMPOINTS ?
				     ( width()/NUMPOINTS ) + 15 : ( width()/NUMPOINTS) ) ,
			   (height()-25-tmtfifo[(tmtptr+x-1)]), 
			   x * width()/NUMPOINTS , 
			   (height()-25-tmtfifo[(tmtptr+x)]  ) ); /* 0 is at the top */ 
		tmp=height()-25-tmtfifo[(tmtptr+x-1)];
	}
    }
}
