#ifndef KWVDIAL_H 
#define KWVDIAL_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include "wvstring.h"
#include "wvdial/wvdialer.h"
#include "configfile/wvconf.h"

#include "kwvdialwidget.h"
#include "kwvdialdock.h"

#include <kapp.h>
#include <ktmainwindow.h>
#include <kwin.h>
#include <kmenubar.h>
#include <klocale.h>

#include <time.h>

//Bunch of stuff that lets us find IP address of the PPP Interface
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <arpa/inet.h>


class Kwvdial : public KTMainWindow
{
	Q_OBJECT
public:
	Kwvdial(QWidget *parent = 0, const char *name = 0);
	virtual ~Kwvdial();

        WvConf        cfg;

public slots:
        void 	wvconnect(int id);
        void 	wvdisconnect();
        void 	gettraffic();

protected slots:
	void 	viewiconic();
	void 	invokeHelp();
	void 	wvabout();
        void 	wvtimer();
	void 	fillmenu();
	void 	getPPPIPaddr();

private:
	bool	isKDEWm();
	
    	KMenuBar   	*menuBar;
    	KStatusBar 	*statusBar;
    	QPopupMenu	*file_menu;
	QPopupMenu	*view_menu;
    	QPopupMenu 	*connect_menu;
	QPopupMenu	*help_menu;
	
	QTimer		*timer;    
    	WvDialer     	*dialer;
    	WvStringList 	*sections;
    	WvLog	 	log;
    
    	KwvdialWidget 	*logview;
    	KwvdialDock   	*KWVDock;

	time_t		currenttime;
    	time_t		connecttime;
    	int		timeonline;
    	long 		rcv;
    	long 		tmt;
    	in_addr		*pppaddr;
	int		rate;
};

#endif // KWVDIAL_H 
