#include "kwvdial.h"
#include <kapp.h>
#include <unistd.h>
#include <sys/types.h>
#include <qmessagebox.h>

int main(int argc, char *argv[])
{
    uid_t uid,euid;
    FILE *file;
    
    uid = getuid();
    euid = geteuid();
    
    KApplication app(argc, argv, "KWvDial");
    Kwvdial *widget = new Kwvdial;
    app.setMainWidget(widget);
    
    if ( ( uid == 0 ) || ( euid == 0) )
    {
	// warn about running this as root and give option to quit or continue
	switch(QMessageBox::warning(NULL,"KWvDial",
				    "This program is not designed to run"
				    "as root,\n or with root permissions. Doing so is a"
				    "potential\n security hole, do"
				    "you really want to do this?\n",
				    QMessageBox::Ok,QMessageBox::Cancel))
	{
	case QMessageBox::Cancel:
	    exit(1);
	    break;
	case QMessageBox::Ok:
	    break;
	}
    }
    
    file = fopen("/etc/wvdial.conf","r");
    if (file != NULL)
    {
	fclose(file);
	file = fopen("/etc/wvdial.conf","r+");
	if (file != NULL)
	{
	    fclose(file);
	} else {
	    // Warn the user that they won't be able to permanently
	    // change any of the configurations 
	    QMessageBox::warning(NULL,"KWvDial","Due to the file"
				 "permissions on /etc/wvdial.conf\n"
				 "you will be unable to change any"
				 "of the settings during this session");
	}
    } else {
	file = fopen("/etc/wvdial.conf","w+");
	if (file !=NULL)
	{
	    // File just doesn't exist - but can be created - warn the
	    // user that they will have to autodetect the modem before
	    // they are able to get online
	    fclose(file);
	    unlink("/etc/wvdial.conf");
	    QMessageBox::warning(NULL,"KWvDial","The file"
				 "/etc/wvdial.conf does not exist\n"
				 "which indicates that KWvDial has not yet been configured\n"
				 "You will have to run the autodetect from\n"
				 "the configuration tab before you can start");
	} else {
	    
	    // File doesn't exist, and can't be created - tell the user
	    // what happened and exit
	    QMessageBox::warning(NULL,"KWvDial","Sorry, I can't"
				 "find /etc/wvdial.conf, and can't\n"
				 "create a new one, I will exit \nso you can run wvdialconf as root, but then make sure"
				 "that the current user is a member\nof a group with at least read rights to"
				 "this file");
	    exit(1);
	}
    }
    file = fopen("/var/lock/ppp.lock","w+");
    if (file != NULL)
    {
	fclose(file);
	unlink("/var/lock/ppp.lock");
    } else {
	// issue warning about incorrect file permissions	
	QMessageBox::warning(NULL,"KWvDial","Unable to create lock file.\n"
			     "Please make sure the current user is a member of a group with\n"
			     "read/write access to /var/lock");
	exit(1);
    }
    
    if ( !access("pppd",X_OK) )
    {
	// issue warning about incorrect group membership
	//	exit(1)	
    }
    
    if ((!access("/dev/modem",R_OK || W_OK)) ||  
	(!access("/dev/ttyS0",R_OK || W_OK)) ||
	(!access("/dev/ttyS1",R_OK || W_OK))   )
    {
	// issue warning about incorrect group membership
    }
    
    widget->resize(640,400);
    widget->show();
    
    return app.exec();
}
