/***************************************************************************
                          kexchange.cpp  -  description
                             -------------------
    begin                : Mon Mar  4 11:43:40 EET 2002
    copyright            : (C) 2002 by Tero Favorin
    email                : tero@favorin.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for QT
#include <qprinter.h>
#include <qpainter.h>
#include <qtabwidget.h>
#include <qclipboard.h>
#include <qdragobject.h>

// include files for KDE
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kmenubar.h>
#include <kstatusbar.h>
#include <klocale.h>
#include <kconfig.h>
#include <kstdaction.h>
#include <kkeydialog.h>
#include <kedittoolbar.h>
#include <kstddirs.h>
#include <ktip.h>

// application specific includes
#include "kexchange.h"
#include "kexconvert.h"
#include "kextable.h"
#include "kexpacific.h"
#include "kexpreferences.h"

#define ID_STATUS_MSG 1

KexchangeApp::KexchangeApp(QWidget* , const char* name):KMainWindow(0, name)
{
  config=kapp->config();
	preferences=NULL;
  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  initStatusBar();
  initActions();
	
  readOptions();

  // Create widgets
	tabs=new QTabWidget(this);
	setCentralWidget(tabs);
	connect ( tabs,SIGNAL(currentChanged ( QWidget * )),this, SLOT (slotTabChanged( QWidget * )) );

	data=new KExPacific(this);
  connect (data, SIGNAL(status ( int, const QString & ) ), this, SLOT (slotDataStatus ( int, const QString & ) ) );
  connect (data, SIGNAL(dataReady() ), this, SLOT (slotDataReady() ) );

	convert=new KExConvert(this);
	convert->setOptions(data,showEuro);
	convert->setExchange(config->readEntry("ToCurrency", "DEM"),config->readEntry("FromCurrency", "EUR"));
	tabs->addTab(convert,i18n("Convert currency"));	

	table=new KExTable(this);
	table->setOptions(data,showEuro);
	table->setBase(config->readEntry("BaseCurrency", "EUR"));
	tabs->addTab(table,i18n("Exchange rates"));

	KTipDialog::showTip (this,locate( "datadir","tips"));
	if ( autoUpdate && lastUpdate.addSecs(60*60*12) < QDateTime::currentDateTime() )
		slotViewRefresh();
}

KexchangeApp::~KexchangeApp() {
	delete data;
}

void KexchangeApp::initActions()
{
//  filePrint = KStdAction::print(this, SLOT(slotFilePrint()), actionCollection());
  fileQuit = KStdAction::quit(this, SLOT(slotFileQuit()), actionCollection());
  editCopy = KStdAction::copy(this, SLOT(slotEditCopy()), actionCollection());
  editPaste = KStdAction::paste(this, SLOT(slotEditPaste()), actionCollection());
  viewToolBar = KStdAction::showToolbar(this, SLOT(slotViewToolBar()), actionCollection());
  viewStatusBar = KStdAction::showStatusbar(this, SLOT(slotViewStatusBar()), actionCollection());
	editSwitch = new KAction(i18n("Switch"), "rotate", Key_S, this, SLOT(slotEditSwitch()), actionCollection(), "edit_switch");
	viewRefresh = new KAction(i18n("Refresh"), "reload", Key_R, this, SLOT(slotViewRefresh()), actionCollection(), "view_refresh");
  setPreferences = KStdAction::preferences( this, SLOT( slotPreferences() ), actionCollection() );
  setAccels = KStdAction::keyBindings( this, SLOT( slotConfAccels() ), actionCollection() );
  setToolbar = KStdAction::configureToolbars( this, SLOT( slotEditToolbars() ), actionCollection() );
	helpTip = new KAction(i18n("Tip of the Day"),"idea",0, this, SLOT(slotShowTip()), actionCollection(), "help_tip");

//  filePrint ->setStatusText(i18n("Prints out the currency rates table"));
  fileQuit->setStatusText(i18n("Quits the application"));
  editCopy->setStatusText(i18n("Copies the converted currency amount to the clipboard"));
  editPaste->setStatusText(i18n("Pastes the clipboard contents to currency conversion field"));
  editSwitch->setStatusText(i18n("Switch from and to currencies"));
  viewRefresh->setStatusText(i18n("Refresh currency data from the net"));
  viewToolBar->setStatusText(i18n("Enable/disable the toolbar"));
  viewStatusBar->setStatusText(i18n("Enable/disable the statusbar"));

  // use the absolute path to your kexchangeui.rc file for testing purpose in createGUI();
  createGUI();
}

void KexchangeApp::initStatusBar()
{
  statusBar()->insertItem(i18n("Ready"), ID_STATUS_MSG, 1,true);
	statusBar()->setItemAlignment (ID_STATUS_MSG, AlignLeft);
}

void KexchangeApp::saveOptions()
{	
  config->setGroup("General Options");
  config->writeEntry("Geometry", size());
  config->writeEntry("GeometryPos",pos());
  config->writeEntry("Show Toolbar", viewToolBar->isChecked());
  config->writeEntry("Show Statusbar",viewStatusBar->isChecked());
  config->writeEntry("ToolBarPos", (int) toolBar("mainToolBar")->barPos());
	config->writeEntry("FromCurrency", convert->getFrom());
	config->writeEntry("ToCurrency", convert->getTo());
	config->writeEntry("BaseCurrency", table->getBase());
	config->writeEntry("ShowEuro", showEuro);
	config->writeEntry("AutoUpdate", autoUpdate);
	config->writeEntry("LastUpdate", lastUpdate);
}

void KexchangeApp::readOptions()
{
  config->setGroup("General Options");

  // bar status settings
  bool bViewToolbar = config->readBoolEntry("Show Toolbar", true);
  viewToolBar->setChecked(bViewToolbar);
  slotViewToolBar();

  bool bViewStatusbar = config->readBoolEntry("Show Statusbar", true);
  viewStatusBar->setChecked(bViewStatusbar);
  slotViewStatusBar();

  // bar position settings
  KToolBar::BarPosition toolBarPos;
  toolBarPos=(KToolBar::BarPosition) config->readNumEntry("ToolBarPos", KToolBar::Top);
  toolBar("mainToolBar")->setBarPos(toolBarPos);

	// Restore options
	showEuro=config->readBoolEntry("ShowEuro",true);
	autoUpdate=config->readBoolEntry("AutoUpdate",false);
	QDateTime deftime=QDateTime(QDate(1900,1,1));
	lastUpdate=config->readDateTimeEntry("LastUpdate",&deftime);

	// Restore size & position
	QSize defsize(450,400);
  QSize size=config->readSizeEntry("Geometry", &defsize);
  QPoint pos=config->readPointEntry("GeometryPos");
  resize(size);
	if (!pos.isNull())
	  move(pos);
}

bool KexchangeApp::queryExit()
{
  saveOptions();
  return true;
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

void KexchangeApp::slotFilePrint()
{
  slotStatusMsg(i18n("Printing..."));
 /*
  QPrinter printer;
  if (printer.setup(this))
  {
    view->print(&printer);
  }
*/
  slotStatusMsg(i18n("Ready"));
}

void KexchangeApp::slotFileQuit()
{
  saveOptions();
  kapp->quit();
}

void KexchangeApp::slotEditCopy()
{
	kapp->clipboard()->setData(new QTextDrag(convert->getOutput()));
}

void KexchangeApp::slotEditPaste()
{
  QString text;
  if ( QTextDrag::decode(kapp->clipboard()->data(), text) )
        convert->setInput(text);
}
void KexchangeApp::slotEditSwitch() {
	convert->setExchange(convert->getFrom(),convert->getTo());
}
void KexchangeApp::slotViewRefresh() {
	lastUpdate=QDateTime::currentDateTime();
	viewRefresh->setEnabled(false);
	data->refresh();
}
void KexchangeApp::slotViewToolBar()
{
  // turn Toolbar on or off
  if(!viewToolBar->isChecked())
  {
    toolBar("mainToolBar")->hide();
  }
  else
  {
    toolBar("mainToolBar")->show();
  }		
}

void KexchangeApp::slotViewStatusBar()
{
  //turn Statusbar on or off
  if(!viewStatusBar->isChecked())
  {
    statusBar()->hide();
  }
  else
  {
    statusBar()->show();
  }
}
void KexchangeApp::slotConfAccels()
{
  KKeyDialog::configureKeys( actionCollection(), xmlFile() );
}
void KexchangeApp::slotEditToolbars()
{
  KEditToolbar dlg( actionCollection() );
  if ( dlg.exec() )
    createGUI();
}
void KexchangeApp::slotPreferences()
{
	if (preferences==NULL)
		preferences=new KExPreferences(this);
	preferences->reset();
	preferences->show();
}
void  KexchangeApp::slotShowTip() {
	KTipDialog::showTip (this,locate( "datadir","tips"),true);
}
void KexchangeApp::slotTabChanged( QWidget * w) {
 	if (w==convert) {
   	editSwitch->setEnabled(true);
   	editCopy->setEnabled(true);
   	editPaste->setEnabled(true);
	}
	if (w==table) {
   	editSwitch->setEnabled(false);
   	editCopy->setEnabled(false);
   	editPaste->setEnabled(false);
	}
}
void KexchangeApp::slotDataReady() {
	viewRefresh->setEnabled(true);
	QString from=convert->getFrom();
	QString to=convert->getTo();
	QString base=table->getBase();
	convert->setOptions(data,showEuro);
	convert->setExchange(to,from);
	table->setOptions(data,showEuro);	
	table->setBase(base);
}
void KexchangeApp::slotDataStatus(int s, const QString &text) {
 	slotStatusMsg(text);
}
void KexchangeApp::slotStatusMsg(const QString &text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  statusBar()->clear();
  statusBar()->changeItem(text, ID_STATUS_MSG);
}
