/***************************************************************************
                          kexconvert.cpp  -  description
                             -------------------
    begin                : Mon Mar 4 2002
    copyright            : (C) 2002 by Tero Favorin
    email                : tero@favorin.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qvbox.h>
#include <qvgroupbox.h>
#include <qlayout.h>
#include <qpixmap.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

#include <kstddirs.h>
#include <klocale.h>
#include <kcombobox.h>
#include <kdialog.h>
#include <knumvalidator.h>

#include "kexconvert.h"
#include "kexdatasource.h"
#include "kexsource.h"

KExConvert::KExConvert(QWidget * parent=0, const char * name=0, WFlags f=0):QWidget(parent,name,f) {
QGridLayout *layout =new QGridLayout(this,5,3,KDialog::marginHint(),KDialog::spacingHint());
layout->setRowStretch(4, 5);
layout->setColStretch(1, 1);

from=new QLabel(i18n("From"),this);
layout->addWidget(from,0,0);
fromCombo=new KComboBox(this);
QToolTip::add( fromCombo, i18n("Currency to convert from") );
QWhatsThis::add( fromCombo, i18n("This is the currency which you want to convert to another currency.") );
layout->addWidget(fromCombo,0,1);
connect (fromCombo,SIGNAL(activated(int)),this,SLOT(updateRate(int)));

QHBox *fromBox=new QHBox(this);
fromBox->setSpacing(KDialog::spacingHint());
layout->addWidget(fromBox,1,1);
input=new KLineEdit(fromBox);
input->setAlignment(AlignRight);
input->setValidator(new KFloatValidator(this));
input->setMaxLength(16);
QToolTip::add( input, i18n("Amount of currency to convert") );
QWhatsThis::add( input, i18n("This is the amount of currency units you want to convert to another currency.") );
connect (input,SIGNAL(textChanged(const QString&)),this,SLOT(update(const QString&)));
fromCur=new QLabel(fromBox);
QToolTip::add( fromCur, i18n("Currency unit of currency being converted") );

to=new QLabel(i18n("To"),this);
layout->addWidget(to,2,0);
toCombo=new KComboBox(this);
QToolTip::add( toCombo, i18n("Currency to convert to") );
QWhatsThis::add( toCombo, i18n("This is the currency which you are converting to.") );

layout->addWidget(toCombo,2,1);
connect (toCombo,SIGNAL(activated(int)),this,SLOT(updateRate(int)));

QHBox *toBox=new QHBox(this);
toBox->setSpacing(KDialog::spacingHint());
layout->addWidget(toBox,3,1);
output=new QLabel("0.00",toBox);
output->setAlignment(AlignRight);
QToolTip::add( output, i18n("Converted amount") );
QWhatsThis::add( output, i18n("This is the amount that has been converted from another currency.") );
toBox->setStretchFactor(output,5);
toCur=new QLabel(toBox);
QToolTip::add( toCur, i18n("Currency code of converted currency") );

QVGroupBox *rateBox=new QVGroupBox(i18n("Exchange rate"),this);
rateBox->setMargin(KDialog::marginHint());
rate=new QLabel(rateBox);
QToolTip::add( rate, i18n("Exchange rate between selected currencies") );
QWhatsThis::add( rate, i18n("This is the exchange rate used in currency conversion.\n\nNote that cross conversion rates between national currency units of euro are only indicative and are not used in actual calculation.") );
rateText2=new QLabel("Rate as of",rateBox);
rateDate=new QLabel(rateBox);
QToolTip::add( rateDate, i18n("Exchange rate date") );
QWhatsThis::add( rateDate, i18n("This is the date of exchange rate.\n\nFor fixed conversion rates the date when the rate was adopted is shown.") );
layout->addMultiCellWidget(rateBox,0,3,2,2);

source=new KExSource(this);
layout->addMultiCellWidget(source,4,4,0,2,AlignLeft | AlignBottom);

locale=new KLocale();
input->setFocus();
}
KExConvert::~KExConvert(){
}
void KExConvert::setOptions(KExDataSource *d, bool e) {
	QPixmap flag;	

	data=d;
	oldeuro=e;

	source->setSource(data);
	fromCombo->clear();
	toCombo->clear();
	list=data->getCurrencies(oldeuro);
  for ( QStringList::ConstIterator it = list.begin(); it != list.end(); ++it ) {
		flag=data->getFlag(*it);
	  fromCombo->insertItem(flag, data->getCurrencyName(*it));
		toCombo->insertItem(flag, data->getCurrencyName(*it));
  }
}
void KExConvert::setExchange(QString to, QString from) {
	toCombo->setCurrentItem(list.findIndex(to));
	fromCombo->setCurrentItem(list.findIndex(from));	
	updateRate(-1);
}
QString KExConvert::getFrom() {
	return data->getCode(list,fromCombo->currentItem());
}
QString KExConvert::getTo() {
	return data->getCode(list,toCombo->currentItem());
}
void KExConvert::setInput(QString s){
	bool ok;
	locale->readNumber(s,&ok);
	if (ok) {
		input->setText(s);
		update(s);
	}
}
void KExConvert::updateRate( int index ) {
	fromCur->setText(getFrom());
	toCur->setText(getTo());
	KExData exrate=data->getRate(getTo(),getFrom());
	rate->setText(locale->formatNumber(exrate.rate,5));
	rateDate->setText(locale->formatDate(exrate.date,true));
	update(QString::null);
}
void KExConvert::update(const QString& in) {
	bool ok;
	QString str=in;
	if (str.isNull())
		str=input->text();
	double amount=locale->readNumber(str,&ok);
	if (!ok)
		amount=0;
	output->setText(locale->formatNumber(data->convert(getTo(),getFrom(),amount),2));			
}
