/************************************/
/* methods of DevWidget             */
/* methods of InverterWidget        */
/*                                  */
/* inverter dialog for devices      */
/* is part of device prop dialog    */
/*                                  */
/* Andreas Rostin                   */
/* 16.12.98                         */
/*                                  */
/* InverterWidget extension:        */
/* Andreas Rostin                   */
/* 04.03.2000                       */
/************************************/
#include <qwidget.h>
#include <qdialog.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qpaintdevice.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qscrollbar.h>

#include <devw.h>
#include <xdevice.h>
#include <xwire.h>
#include <klogic.h>

#include "devw.moc"

// results in a scrollable device widget
InverterWidget::InverterWidget(QWidget *parent, const char *name, XDevice *_dev)
	: QWidget(parent, name, WStyle_Customize |WStyle_NormalBorder)
{
	dev = _dev;
	curr_y_size = height();
	vscroll = new QScrollBar(0, 195, GRID, 16 * GRID, 0, QScrollBar::Vertical, this);
	vscroll->setGeometry(width() - 10, 0, 10, height());
	vscroll->hide();
	devw = new DevWidget(this, name, _dev);
	devw->show();

	connect(vscroll, SIGNAL(valueChanged(int)), this, SLOT(vScroll(int)));
}

InverterWidget::~InverterWidget()
{
}

void InverterWidget::paintEvent(QPaintEvent *pev)
{	int y;

	QWidget::paintEvent(pev);
	y = dev->getImage()->height();
	if (y != curr_y_size && y > height()) {
		curr_y_size = y;
		devw->setGeometry(0, 0, width() - 10, y + 30);
		vScroll(0);
		vscroll->setRange(0, y - height() + 30);
		vscroll->show();
	}
	if (y < height()) {
		curr_y_size = y;
		vScroll(0);
		vscroll->hide();
	}
	devw->repaint(TRUE);
}

void InverterWidget::setGeometry(int x, int y, int width, int height)
{
	QWidget::setGeometry(x, y, width, height);

	vscroll->setGeometry(width - 10, 0, 10, height);
	if (height > curr_y_size) curr_y_size = height;
	devw->setGeometry(0, 0, width - 10, curr_y_size + 30);
}

void InverterWidget::vScroll(int val)
{
	devw->move(0, -1 * val);
}

void InverterWidget::setInputButtons()
{
	devw->setInputButtons();
}

void InverterWidget::setOutputButtons()
{
	devw->setOutputButtons();
}

//*****************************************************************************
//*****************************************************************************

DevWidget::DevWidget(QWidget *parent, const char *name, XDevice *_dev)
	: QWidget(parent, name, WStyle_Customize |WStyle_NormalBorder)
{	int i;

	dev = _dev;

	setBackgroundMode(PaletteBase);
	setBackgroundColor(white);

	for (i = 0; i < XDevice::MAXSIZE;i++) {
		iswitch[i] = (QCheckBox *)NULL;
		oswitch[i] = (QCheckBox *)NULL;
	}

	// set switches for each input
	bg_i = (QButtonGroup *)NULL;
	setInputButtons();
	// set switches for each output
	bg_o = (QButtonGroup *)NULL;
	setOutputButtons();
}

DevWidget::~DevWidget()
{
}

void DevWidget::paintEvent(QPaintEvent *)
{	QPainter p;

	erase();
	QPixmap *pix = dev->getImage();
	bitBlt(this, (rect().width() - pix->width()) / 2, 15 , pix);

	p.begin(this);
	p.setPen(black);
	p.drawRect(rect());
	p.end();
}

// slot for input-buttons-group
void DevWidget::inputButton(int no)
{	list<XWire> *lw = iwire[no].First();

	while(lw) {
		lw->Get()->invertInput(dev, iswitch[no]->isChecked());
		dev->setImage();
		lw = lw->Next();
	}
	repaint();
}
// slot for input-buttons-group
void DevWidget::outputButton(int no)
{	list<XWire> *lw = owire[no].First();

	while(lw) {
		lw->Get()->invertOutput(oswitch[no]->isChecked());
		dev->setImage();
		lw = lw->Next();
	}
	repaint();
}

void DevWidget::setInputButtons()
{	int i = 0;
	int j, idx;
	QPoint pt;
	QRect re = dev->getPos();
	int y;
	list<XWire> *lw = dev->getIRef()->First();
	XWire *w;
	int cnt;

	if (bg_i) {
		disconnect(bg_i, SIGNAL(clicked(int)), this, SLOT(inputButton(int)));
		for (i = 0; i < XDevice::MAXSIZE;i++) {
			delete iswitch[i];
			iswitch[i] = (QCheckBox *)NULL;
			iwire[i].Destroy();
		}
		delete bg_i;
	}

	i = 0;
	bg_i = new QButtonGroup;
	cnt = 0;
	while (lw && lw->Get()) {
		w = lw->Get();
		idx = w->getConnectionIndex(dev);
		pt = w->getInputPosition(idx);
		y =  pt.y() - re.y() + GRID;
		// each y only once!
		for(j=0;((j < i) && y);j++) {
			if (iswitch[j]->geometry().y() == y) {
				y = 0;
				iwire[j].Append(w);
			}
		}
		if (y) {
			iwire[i].Append(w);
			iswitch[i] = new QCheckBox(this);
			iswitch[i]->setGeometry(5, y, 10 , 10);
			iswitch[i]->setChecked(w->inputIsInverted(dev));
			bg_i->insert(iswitch[i], i);
			i++;
		}
		lw = lw->Next();
	}

	cnt = i;
	connect(bg_i, SIGNAL(clicked(int)), this, SLOT(inputButton(int)));
	for (i = 0; i < cnt; i++) {
		if (iswitch[i]) iswitch[i]->show();
	}
}

void DevWidget::setOutputButtons()
{	int i = 0;
	int j;
	QPoint pt;
	QRect re = dev->getPos();
	int y;
	list<XWire> *lw = dev->getORef()->First();
	XWire *w;
	int cnt;

	if (bg_o) {
		disconnect(bg_o, SIGNAL(clicked(int)), this, SLOT(outputButton(int)));
		for (i = 0; i < XDevice::MAXSIZE;i++) {
			delete oswitch[i];
			oswitch[i] = (QCheckBox *)NULL;
			owire[i].Destroy();
		}
		delete bg_o;
	}

	i = 0;
	bg_o = new QButtonGroup;
	while (lw && lw->Get()) {
		w = lw->Get();
		pt = w->getOutputPosition();
		y =  pt.y() - re.y() + GRID;
		// each y only once!
		for(j=0;((j < i) && y);j++) {
			if (oswitch[j]->geometry().y() == y) {
				y = 0;
				owire[j].Append(w);
			}
		}
		if (y) {
			owire[i].Append(w);
			oswitch[i] = new QCheckBox(this);
			oswitch[i]->setGeometry(85, y, 10 , 10);
			oswitch[i]->setChecked(w->outputIsInverted());
			bg_o->insert(oswitch[i], i);
			i++;
		}
		lw = lw->Next();
	}

	cnt = i;
	connect(bg_o, SIGNAL(clicked(int)), this, SLOT(outputButton(int)));
	for (i = 0; i < cnt; i++) {
		if (oswitch[i]) oswitch[i]->show();
	}
}

