#ifndef __KLOGICIO_CLASS__
#define __KLOGICIO_CLASS__

class QTextStream;
class XDeviceNet;
class QString;

// constants for reading/writing files
#define IO_B_NET "BEGIN NET"
#define IO_E_NET "END NET"
#define IO_B_WIRE "BEGIN WIRE"
#define IO_E_WIRE "END WIRE"
#define IO_B_DEVICE "BEGIN DEVICE"
#define IO_E_DEVICE "END DEVICE"
#define IO_B_SUBNET "BEGIN SUBNET"
#define IO_E_SUBNET "END SUBNET"
#define IO_B_CONNWIRE "BEGIN CONNECTION WIRES"
#define IO_E_CONNWIRE "END CONNECTION WIRES"
#define IO_B_CONNDEVICE "BEGIN CONNECTION DEVICES"
#define IO_E_CONNDEVICE "END CONNECTION DEVICES"

/*********************************************
* read/write a circuit
*********************************************/
class klogicIO
{
public:
	klogicIO(XDeviceNet *);
	klogicIO(QString);
	klogicIO(QString, XDeviceNet *);

	void setSubFilename();
	void setNet(XDeviceNet *);
	int checkSubNet();
	int writeNet(XDeviceNet *_net = (XDeviceNet *)NULL);
	int writeNet(QTextStream *, int, XDeviceNet *_net = (XDeviceNet *)NULL, int minx = 0, int miny = 0);
	int readNet(int);
	int readNet(int, QTextStream *, int, XDeviceNet *_net = (XDeviceNet *)NULL, int dx = 0, int dy = 0);

	int type(QString);
private:
	QString fname;
	XDeviceNet *net;

};

#endif

