/***************************************************/
/* double linked list template                     */
/*  - implementation contained in this file!       */
/*  - two additional string identifiers            */ 
/*                                                 */
/* Andreas Rostin                                  */
/* 22.01.98                                        */
/***************************************************/
#ifndef __LIST_CLASS_T__
#define __LIST_CLASS_T__

#include <stdlib.h>

template <class T> class list
{public:
	list();
	~list();

	int counter();	// no of elements in the list
	int current();	// no of the current element

	// ***** retrieve objects
	inline T *Get(int);
	inline T *Get(T *);
	inline T *Get();
	inline T *Get(char *);

	// ***** the access keys
	inline char * getText();
	inline void setText(const char *);
	inline list<T> * swapText(char *, char *);

	inline int getID1();
	inline void setID1(int);
	inline int getID2();
	inline void setID2(int);

	// ***** navigation
	inline list<T> * First();
	inline list<T> * Last();
	inline list<T> * Prev();
	inline list<T> * Next();

	// ***** search (the first if not unique) element with attribute..
	inline list<T> * With(T *);
	inline list<T> * With(int);
	inline list<T> * With(const char *);
	inline list<T> * With(T *, int);
	inline list<T> * With(T *, int, int);

	// ***** insert/append/replace/destroy
	inline T * Replace(T *new_content, int ida = 0, int idb = 0);
	inline list<T> * Append(T *new_content, int ida = 0, int idb = 0);
	inline list<T> * Insert(T *new_content, int id, T *next_content);
	inline list<T> * Destroy(T *content, int ida = 0, int idb = 0);
	inline list<T> * Destroy(int ida);
	inline list<T> * Destroy();

private:
	list<T> *next;
	list<T> *prev;
	T *tContent;
	char *text;
	int id1;
	int id2;
};

template <class T>
list<T>::list()
{	prev = (list<T> *)NULL;
	next = (list<T> *)NULL;
	tContent = (T *)NULL;
	text = (char *)NULL;
	id1 = 0;
	id2 = 0;
}

template <class T>
list<T>::~list()
{
	if (text) free(text);
}	

template <class T>
inline int list<T>::getID1()
{
	return id1;
}

template <class T>
inline void list<T>::setID1(int id)
{
	id1 = id;
}

template <class T>
inline int list<T>::getID2()
{
	return id2;
}

template <class T>
inline void list<T>::setID2(int id)
{
	id2 = id;
}

template <class T>
inline char * list<T>::getText()
{
	return text;
}

template <class T>
inline void list<T>::setText(const char *newtext)
{	char *newp = (char *)NULL;

	if (newtext) newp = strdup(newtext);
	if (text) free(text);
	text = newp;
}

// replace the current list element
template <class T>
inline T * list<T>::Replace(T *new_content,  int ida = 0, int idb = 0)
{	T *ret = tContent;

	tContent = new_content;
	id1 = ida;
	id2 = idb;
	if (text) free(text);
	text = NULL;
	return ret;
}

template <class T>
inline list<T> * list<T>::Append(T *new_content,  int ida = 0, int idb = 0)
{	list<T> *akt = this;
	list<T> *first = this;

	akt = this;
	while(akt->next) akt = akt->next;
	first = this;
	while(first->prev) first = first->prev;

	// das erste Listenelement existiert..
	if (akt == first) {
		if (akt->tContent == NULL)
		{	akt->tContent = new_content;
			akt->id1 = ida;
			akt->id2 = idb;
			if (text) free(text);
			text = (char *)NULL;
			return this;
		}
	}

	// ..alle weiteren werden hier erzeugt
	akt->next = new list<T>;
	akt->next->prev = akt;
	akt->next->next = (list<T> *)NULL;
	akt->next->tContent = new_content;
	akt->next->id1 = ida;
	akt->next->id2 = idb;
	return akt->next;
}

template <class T>
inline list<T> * list<T>::Insert(T *new_content, int id, T *next_content)
{	list<T> *akt = this->With(next_content);
	list<T> *ins;
	list<T> *first = this;

	// kein Nachfolger-Elememt gefunden..
	if (akt == NULL) return akt;

	while(first->prev) first = first->prev;

	// das erste Listenelement existiert..
	if ((akt == first) && (akt->tContent == NULL)) {
		akt->tContent = new_content;
		akt->id1 = id; 
		return this;
	}

	// ..alle weiteren werden hier erzeugt
	ins = new list<T>;
	if (akt == first) {
		// erstes Element in das neue kopieren
		ins->tContent = akt->tContent;
		ins->prev = akt;
		ins->next = akt->next;
		ins->text = akt->text;
		if (ins->next) ins->next->prev = ins;
		ins->id1 = akt->id1;
		ins->id2 = akt->id2;
		// und das erste Element neu fuellen
		akt->tContent = new_content;
		akt->prev = (list<T> *)NULL;
		akt->next = ins;
		akt->text = (char *)NULL;
		// return the new first element!
		ins = akt;
	} else {
		ins->tContent = new_content;
		ins->next = akt;
		ins->prev = akt->prev;
		if (akt->prev) akt->prev->next = ins;
		akt->prev = ins;
	}

	ins->id1 = id;
	return ins;
}

// destroy by content, name1 and name2, returning next
template <class T>
inline list<T> * list<T>::Destroy(T *content, int ida = 0, int idb = 0)
{	list<T> *akt;
	list<T> *ret;
	list<T> *first = this;

	while(first->prev) first = first->prev;
	akt = first;
	ret = first;

	if (!content) return (list<T> *)NULL;
	while(akt) {
		if ((akt->tContent == content) && (ida == 0 || ida == akt->id1) && (idb == 0 || idb == akt->id2)) {
			if (akt == first) {
				// erstes element kopieren
				akt->tContent = (T *)NULL;
				if (akt->text) free(akt->text);
				akt->text = (char *)NULL;
				akt->id1 = 0;
				akt->id2 = 0;
				if (akt->next) {
					ret = akt->next;
					akt->text = akt->next->text;
					akt->next->text = (char *)NULL;
					akt->tContent = akt->next->tContent;
					akt->id1 = akt->next->id1;
					akt->id2 = akt->next->id2;
					if (akt->next->next) akt->next->next->prev = akt;
					akt->next = akt->next->next;
					delete ret;
				}
				return akt;
			} else {
				if (akt->prev) {
					akt->prev->next = akt->next;
					ret = akt->prev;
				}
				if (akt->next) {
					akt->next->prev = akt->prev;
					ret = akt->next;
				}
				delete akt;
				return ret;
			}
		}
		akt = akt->next;
	}
	return (list<T> *)NULL;
}

// destroy by name, returning next
template <class T>
inline list<T> * list<T>::Destroy(int ida)
{	list<T> *akt;
	list<T> *ret;
	list<T> *first = this;

	while(first->prev) first = first->prev;
	akt = first;
	ret = first;

	while(akt)
	{	if (akt->id1 == ida) {
			// all list-entries but the first are allocated by the first
			if (akt == first) {
				akt->tContent = (T *)NULL;
				if (akt->text) free(akt->text);
				akt->text = (char *)NULL;
				akt->id1 = 0;
				akt->id2 = 0;
				if (akt->next) {
					ret = akt->next;
					akt->tContent = akt->next->tContent;
					akt->id1 = akt->next->id1;
					akt->id2 = akt->next->id2;
					akt->text = akt->next->text;
					akt->next->text = (char *)NULL;
					if (akt->next->next) akt->next->next->prev = akt;
					akt->next = akt->next->next;
					delete ret;
					return akt;
				}
				return akt;
			}
			else {
				if (akt->prev) {
					akt->prev->next = akt->next;
					ret = akt->prev;
				}
				if (akt->next) {
					akt->next->prev = akt->prev;
					ret = akt->next;
				}
				delete akt;
				return ret;
			}
		}
		akt = akt->next;
	}
	return ret;
}

// destroy all elements
template <class T>
inline list<T> * list<T>::Destroy()
{	list<T> *akt;
	list<T> *nextakt;
	list<T> *first = this;

	while(first->prev) first = first->prev;
	akt = first;

	while(akt)
	{	nextakt = akt->next;
		if (akt == first) {
			akt->tContent = (T *)NULL;
			if (akt->text) free(akt->text);
			akt->text = (char *)NULL;
			akt->id1 = 0;
			akt->id2 = 0;
		}
		else {
			akt->prev->next = akt->next;
			if (akt->next) akt->next->prev = akt->prev;
			delete akt;
		}
		akt = nextakt;
	}
	return first;
}

template <class T>
inline T * list<T>::Get(int id)
{	list<T> *akt = this;

	while (akt) {
		if (akt->id1 == id) return akt->tContent;
		akt = akt->next;
	}
	akt = this;
	while (akt->prev) {
                if (akt->prev->id1 == id) return akt->prev->tContent;
                akt = akt->prev;                                                                                                      
	}
	return (T *)NULL;
}

template <class T>
inline T * list<T>::Get(T *searched)
{	list<T> *akt = this;

	while (akt) {
		if (akt->tContent == searched)
			return searched;
		akt = akt->next;
	}
	akt = this;
	while (akt->prev) {
		if (akt->prev->tContent == searched) return searched;
		akt = akt->prev;
	}
	return (T *)NULL;
}

template <class T>
inline T * list<T>::Get(char *searched)
{	list<T> *akt = this;

	while (akt) {
		if (!strcmp(akt->text, searched)) 
			return tContent;
		akt = akt->next;
	}
	akt = this;
	while (akt->prev) {
		if (!strcmp(akt->prev->text, searched)) return akt->prev->tContent;
		akt = akt->prev;
	}
	return (T *)NULL;
}

template <class T>
inline T * list<T>::Get()
{	return this->tContent;
}

template <class T>
inline list<T> * list<T>::swapText(char *searched, char *newtext)
{	list<T> *akt = this;
	char *newp = (char *)NULL;

	while (akt) {
		if (!strcmp(akt->text, searched)) {
			if (newtext && strlen(newtext)) newp = strdup(newtext);
			if (akt->text) free(akt->text);
			akt->text = newp;
			return akt;
		}
		akt = akt->next;
	}
	akt = this;
	while (akt->prev) {
		if (!strcmp(akt->prev->text, searched)) {
			if (newtext && strlen(newtext)) newp = strdup(newtext);
			if (akt->prev->text) free(akt->prev->text);
			akt->prev->text = newp;
			return akt->prev;
		}
		akt = akt->prev;
	}
	return (list<T> *)NULL;
}

template <class T>
inline list<T> * list<T>::With(T *searched)
{	list<T> *akt = this;

	while (akt) {
		if (akt->tContent == searched) return akt;
		akt = akt->next;
	}
	akt = this;
	while(akt->prev) {
		if (akt->prev->tContent == searched) return akt;
		akt = akt->prev;
	}
	return (list<T> *)NULL;
}

template <class T>
inline list<T> * list<T>::With(const char *searched)
{	list<T> *akt = this;

	if (!searched) return (list<T> *)NULL;

	while(akt) {
		if (akt->text && !strcmp(akt->text, searched)) return akt;
		akt = akt->next;
	}
	akt = this;
	while (akt->prev) {
		if (!strcmp(akt->prev->text, searched)) return akt->prev;
		akt = akt->prev;
	}
	return (list<T> *)NULL;
}

template <class T>
list<T> * list<T>::With(int id)
{	list<T> *akt = this;

	while (akt) {
		if (akt->id1 == id) return akt;
		akt = akt->next;
	}
	akt = this;
	while(akt->prev) {
		if (akt->prev->id1 == id) return akt->prev;
		akt = akt->prev;
	}
	return (list<T> *)NULL;
}

template <class T>
inline list<T> * list<T>::With(T *searched, int id)
{	list<T> *akt = this;

	while (akt) {
		if (akt->tContent == searched && akt->id1 == id) return akt;
		akt = akt->next;
	}
	akt = this;
	while(akt->prev) {
		if (akt->prev->tContent == searched && akt->prev->id1 == id) return akt->prev;
		akt = akt->prev;
	}
	return (list<T> *)NULL;
}

template <class T>
inline list<T> * list<T>::With(T *searched, int ida, int idb)
{	list<T> *akt = this;

	while (akt) {
		if (akt->tContent == searched && akt->id1 == ida && akt->id2 == idb) return akt;
		akt = akt->next;
	}
	akt = this;
	while(akt->prev) {
		if (akt->prev->tContent == searched && akt->prev->id1 == ida && akt->prev->id2 == idb)
			return akt->prev;
		akt = akt->prev;
	}
	return (list<T> *)NULL;
}

template <class T>
inline list<T> * list<T>::First()
{	list<T> *akt = this;

	while(akt->prev) akt = akt->prev;

	if (tContent) return akt;
	return (list<T> *)NULL;
}

template <class T>
inline list<T> * list<T>::Last()
{	list<T> *akt = this;

	while (akt->next) akt = akt->next;

	if (tContent) return akt;
	return (list<T> *)NULL;
}

template <class T>
inline list<T> * list<T>::Prev()
{	if (prev && prev->tContent) return prev;
	return (list<T> *)NULL;
}

template <class T>
inline list<T> * list<T>::Next()
{	if (next && next->tContent) return next;
	return (list<T> *)NULL;
}

template <class T>
inline int list<T>::counter()
{	list<T> *akt = this;
	int ret = 0;

	while(akt->prev) akt = akt->prev;
	while (akt) {
		if (akt->tContent) ret++;
		akt = akt->next;
	}
	return ret;
}

template <class T>
inline int list<T>::current()
{	list<T> *akt = this;
	int ret = 0;

	while (akt->prev) {
		if (akt->tContent) ret++;
		akt = akt->prev;
	}
	return ret;
}

#endif

