#ifndef __Wire_CLASS__
#define __Wire_CLASS__

#include <list.h>
#include <device.h>
#include <qpixmap.h>
#include "xdevice.h"

/********************************************
* node handling of all nodes of a wire 
*********************************************/
class Wire
{
public:
	Wire();
	Wire(QPoint);
	~Wire();

	// draw wire
	void drawImage(QPainter *);
	void setColor(QColor);

	// import/export mothods
	QString wire2string(int selonly, int dx = 0, int dy = 0);
	int string2wire(const char *, int dx = 0, int dy = 0);

	// called by XDevice
	// modify input- and output-nodes by devices (device-move)
	void setInputPosition(QPoint);
	void setInputPosition(QPoint, int);
	QPoint getInputPosition(int idx, int selonly = 0);
	void setOutputPosition(QPoint);
	QPoint getOutputPosition(int selonly = 0);
	// get io-position of connected wire
	QPoint getIOPosition(int idx, int selonly = 0);

	// called by NetDevice
	void garbageCollection();
	QPoint getActive();
	int activeIsInput();
	int activeIsOutput();
	int activeIsEnd();
	int countNodes();
	int lockNode(QPoint);
	int lockLastNode();
	int lockSelectedNode();

	// called by Selection
	int getMinSelX();
	int getMaxSelX();
	int getMinSelY();
	int getMaxSelY();
	void addPos(int, int);
	int isSelected();

	// constants
	static const int NODE_NOLOCK = 0;
	static const int NODE_SINGLE=1;
	static const int NODE_FRONT=2;
	static const int NODE_MIDDLE=3;

protected:
	// erase whole wire (usually use erase)
	void eraseWire(QPainter *);
	// erase active node and end nodes
	void erase(QPainter *);
	// draw all nodes
	void draw(QPainter *);
	// draw grid into rect
	void restoreArry(QPainter *p, int, int, int, int);
	void drawSolderedPoint(QPainter *, QColor, QPoint);

	// wire modifying methods
	list<QPoint> *contains(QPoint);
	int lockNode(list<QPoint> *);
	int lockNode(QPoint *);
	int nodeIsReference(QPoint *);
	int nodeIsForeign(QPoint *);
	int nodeIsInput(QPoint *);
	int nodeIsOutput(QPoint *);
	int isPart(QPoint *);

	// operations on active (locked) node
	int createNode(QPoint);		// set active node
	void updateNode(QPoint);	// update position of active node
	void cutNode();			// will not destroy it!
	void removeNode();		// destroys active node
	void releaseNode();
	QPoint *getActiveNode();
	int activeIsReference();	// node is only a copy
	int activeIsForeign();		// also part of another wire
	int getActiveConnIndex();

	// called by XWire: connection methods
	int connectInput();
	void disconnectInput(int);
	int connectOutput();
	void disconnectOutput();
	int connectWire(int);
	void disconnectWire(int);
	QPoint *checkConnection(QPoint *);

	// wire-part selctions
	int select(QRect, int);
	void unselect();

private:
	// calculation operations (connection detection)
	int derive(QPoint, QPoint, QPoint);
	int inBetween(QPoint, QPoint, QPoint);
	QPoint * align(QPoint *);

	// all nodes of this wire
	list<QPoint> wire;

	// all currenty selected nodes of this wire
	list<QPoint> selnode;

	// connection management
	// *****************************************************
	// node of wire, which is input-node (input of a device)
	QPoint *input1;
	QPoint *input2;

	// node of wire, which is output-node (output of a device)
	QPoint *output;

	// connection nodes (wire-wire-connections)
	QPoint *io_p1, *io_p2;

	// connection nodes of other wires (references)
	list<QPoint> io_p;
	// *****************************************************

	// moving and drawing management
	// *****************************************************
	// last position of the locked node at time of its drawing
	QPoint o_node;
	QPoint o_start_node;
	QPoint o_end_node;
	// last wire-course (node inserted if not null)
	QPoint o_ins_node1, o_ins_node2;

	// actual locked node with predecessor and successor
	QPoint *from_node;
	QPoint *current_node;
	QPoint *to_node;

	// current color of the wire
	QColor color;

	int MustErase;
	// *****************************************************
};

#endif
