#include <stdio.h>
#include <iostream>
#include <string.h>

#include <qpopupmenu.h>
#include <qkeycode.h>
#include <qfile.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qtimer.h>

#include <kmenubar.h>
#include <kstatusbar.h>
#include <kpmatrix.h>
#include <kmsgbox.h>
#include <kprogress.h>
#include <kapp.h>
#include <kpcomm.h>
#include <kfiledialog.h>
#include <kurl.h>
#include <ktreelist.h>
#include <kprocess.h>
#include <kmsgbox.h>
#include <kstdaccel.h>

#include "kpsimple.h"

//Won't run KPlot (for debugging)
#define DONTRUN


//SOCKNAME will be a command-line option.
#define SOCKNAME "/tmp/kplotcomm"

//Statusbar
const int S_MAIN=1;

const int MAXCONNECTTRIES=10;
const int CONNECTTIMEOUT=200;


const int TREEROOT = 0;

KPSimple::KPSimple (const char *name) :
  KTMainWindow (name)
{
  KStdAccel keys;

  file = new QPopupMenu;
  idimportmatrix=file->insertItem ("&Import Matrix...", this, SLOT(slotImport()),
		    CTRL+Key_I);
  file->insertItem ("&Quit", kapp, SLOT(quit()), keys.quit());
  //  idaddmatrix=file->insertItem ("&Add Matrix...", this, SLOT(slotAdd()),  CTRL+Key_A);
  //  idreload=file->insertItem ("&Reload...", this, SLOT(slotReload()),CTRL+Key_R);        
  menuBar()->insertItem ("&File", file);

  menuBar()->insertSeparator();
  menuBar()->insertItem ("&Help", kapp->getHelpMenu (false, i18n("This is an example KPlot client") ));

  KStatusBar *ks = statusBar();
  //  ks->setInsertOrder (KStatusBar::RightToLeft);
  ks->insertItem (" ", S_MAIN);


  dirpath = "";

  tree = new KTreeList (this);
  tree->insertItem ("Page 1", 0);
  connect ( tree, SIGNAL(highlighted(int)),
	    SLOT (slotHighlighted (int)) );

  setView (tree);


  statusBar()->changeItem ("Starting KPlot", S_MAIN);
#ifndef DONTRUN
  startKPlot();
#endif

  connectmessage = "Establishing data connection";
  statusBar()->changeItem (connectmessage, S_MAIN);
  connecttries=0;
  QTimer::singleShot (CONNECTTIMEOUT, this, SLOT(slotMakeConnection()));


  resize (400,150);
}

void
KPSimple::startKPlot (void)
{
  kproc = new KProcess;

  QString qs ("-socket ");
  qs += SOCKNAME;
  *kproc << "kplot" << qs;


  connect ( kproc, 
	    SIGNAL (receivedStdout(KProcess *, char *, int )),
	    this,
	    SLOT ( slotOutput(KProcess *, char *, int)) );
  connect ( kproc, 
	    SIGNAL (receivedStderr(KProcess *, char *, int )),
	    this,
	    SLOT ( slotOutput(KProcess *, char *, int)) );
  kproc->start  (KProcess::NotifyOnExit, KProcess::All);
}

void
KPSimple::closeEvent (QCloseEvent *ce)
{
#ifndef DONTRUN
  if (kproc->isRunning())
      kproc->kill();
#endif
  KTMainWindow::closeEvent (ce);
}

void
KPSimple::slotConnectionLost (KSocket *)
{
  close();
}

void
KPSimple::slotMakeConnection()
{
  kpcomm = new KPComm(SOCKNAME);
  printf ("SOCK  %d\n",kpcomm->socket());
  if (kpcomm->socket()==-1)
    {
      connectmessage+=".";
      statusBar()->changeItem (connectmessage, S_MAIN);
      connecttries++;

      delete kpcomm;
      if (connecttries>MAXCONNECTTRIES)
	{
	  statusBar()->changeItem (i18n("Connect failed"), S_MAIN);
	  KMsgBox::message (0, i18n("Connection failed"), i18n("Could not establish a"
		   " connection to KPlot."), KMsgBox::STOP, i18n("Quit"));
	  close();
	}
      else
	{
	  QTimer::singleShot (CONNECTTIMEOUT, this, SLOT(slotMakeConnection()));
	}
      return;
    }

  connect ( kpcomm, SIGNAL (messageWaiting (int)),
            this, SLOT (slotMessageWaiting (int)) );
  connect ( kpcomm, SIGNAL (closeEvent (KSocket *)),
            this, SLOT (slotConnectionLost (KSocket*)) );
  
}

void
KPSimple::slotMessageWaiting (int message)
{
  char *data=0;
  int datasize, id, option;
  data = (char *)kpcomm->get (message, option, datasize, id);

  printf ("CLIENT:  message is [%d]\n", message);
  printf ("CLIENT:  option is [%d]\n", option);
  kpcomm->releaseData (data, id);
}

void
KPSimple::slotImport ()
{
  printf ("IMPORT\n");
  QString data ("Hello");
  printf ("CLIENT SENDING [%s]\n", (const char *)data);
  kpcomm->send (KPComm::NOP, 0, (const char *)data, sizeof (char)*strlen(data));


  //  We'd like to have the open dialog say "Import matrix"
  //  KFileDialog fd (dirpath);
  //  fd.setCaption("Import Matrix");

  QString filename = KFileDialog::getOpenFileName(dirpath);

  if (filename.isNull())
    return;
  
  KURL url (filename);
  dirpath = url.directory();

  createFromFile (filename);
}

void
KPSimple::createFromFile (QString filename, bool add)
{
  //Turn off the *flood* of signals from KSocket
  kpcomm->enableRead (false);
  kpcomm->enableWrite (false);

  KPMatrix *m=loadMatrix (filename);

  kpcomm->enableRead (true);
  kpcomm->enableWrite (true);

  if (!m)
    return;

  //Send matrix description to KPlot
  KURL url (filename);
  QString matrixname (url.filename());
  matrixname.truncate (254);
  
  SKPCMatrixDesc matdesc;
  matdesc.nrows = m->nRows();
  matdesc.ncols = m->nCols();
  strcpy (matdesc.name, matrixname);

  

  int matrixid = rand();
  kpcomm->send (KPCMatrixDesc, matrixid, &matdesc, sizeof (SKPCMatrixDesc));
  
  //Send matrix data to KPlot
  kpcomm->send (KPCMatrix, matrixid, m->matrix(), 
		m->nRows()*m->nCols()*sizeof (double));

  //  updateMenusEtc ();

  QString qs ("Imported ");
  qs += filename;
  statusBar()->changeItem ((const char *)qs, S_MAIN);

  if (add)
    {
      //Add everything to page 1 right now.
      SIndexedMatrixDesc *md = new SIndexedMatrixDesc;
      memcpy (&md->matdesc, &matdesc, sizeof (SKPCMatrixDesc));
      
      tree->addChildItem (matrixname, 0, TREEROOT);
      md->index=tree->currentItem();
      md->filename = filename;
      tree->expandItem (0);
      
      matrices.append (md);
    }
}

KPMatrix *
KPSimple::loadMatrix (const QString &filename)
{


  QString qs;
  QFile file (filename);
  file.open (IO_ReadOnly);
  unsigned int size = file.size();

  int e,f,g;
  int savepos;

  qs.sprintf ("Loading %s", (const char *)filename);
  statusBar()->changeItem (qs, S_MAIN);

  if (size==0)
    {
      qs = "Load failed:  Empty file.";
      statusBar()->changeItem (qs, S_MAIN);
      return 0L;
    }


  int nextupdate=0;
  QWidget *dialog = new QWidget (0);
  cancelwid=dialog;
  QGridLayout *layout = new QGridLayout (dialog, 2, 2, 10);
  QLabel *l = new QLabel ("Loading matrix: ", dialog);
  l->setAlignment (AlignRight);
  l->setMinimumSize (l->sizeHint());
  layout->addWidget (l, 0, 0);
  KProgress *prog = new KProgress (0, size, 0, KProgress::Horizontal, dialog);
  //  prog.setBarStyle (KProgress::Blocked);
  prog->setMinimumHeight (1.33*l->sizeHint().height());
  prog->setMinimumWidth (prog->sizeHint().width());
  layout->addWidget (prog, 0, 1);
  QPushButton *cancelbtn = new QPushButton ("&Cancel", dialog);
  cancelbtn->setDefault (false);
  cancelbtn->setMinimumSize (cancelbtn->sizeHint());
  connect ( cancelbtn, SIGNAL (clicked()),
	    this, SLOT (slotCancel()) );
  layout->addMultiCellWidget (cancelbtn, 1, 1, 0, 1);
  
  layout->freeze();

  
  bcanceled=false;
  dialog->setCaption ("Load matrix - KPlot");
  //  QTimer::singleShot (500, this, SLOT (slotShow()) );
  dialog->show();
  dialog->move (mapToGlobal (QPoint( (width() - dialog->width())/2,
				     (height() - dialog->height())/2) ));
  kapp->processEvents();

  //Skip initial comments
  do
    {
      savepos = file.at();
#if QT_VERSION<200
      char *tmp = new char [512];
      e=file.readLine (tmp, 512);
      qs=tmp;
      delete tmp;
#else
      e=file.readLine (qs, 512);
#endif

      if (e<0) //or e<1?
	{
	  delete dialog;
	  KMsgBox::message (this, "Matrix Read Error",
			    "Cannot load matrix.  No data.",
			    KMsgBox::STOP, "OK");
	  qs = "Load failed:  Invalid format.";
	  statusBar()->changeItem (qs, S_MAIN);

	  return 0L;
	}
    } while (qs[0]=='#' || qs[0]=='%' || qs[0]=='\n');



  int nc=0;
  //How many columns?

  //column separators are ' ', ',', ';', ':'
  for (unsigned int i=0;i<qs.length();i++)
    if (qs[i]==',' || qs[i]==';' || qs[i]==':')
      qs[i]=' ';
  QString qs2=qs.simplifyWhiteSpace();
  qs=qs2;

  f=0;
  while ( (f=qs.find (' ', f))!=-1)
    {
      nc++;
      f++;
    }

  nc++;

  KPMatrix *m;
  /*  if (nc==1)
    m = new KPMatrix (2);
    else*/

  m = new KPMatrix (nc);

  file.at(savepos);

  int ir=0, ic=0;
  int ncm1=nc-1;
  int cnt=0;

  //if QT_VERSION<200
  char *tmp;
  tmp = new char [512];
  while (file.readLine (tmp, 512)>0)
    {
      qs=tmp;
      
      //while (file.readLine (qs, 512)>0)
      //    {
      //      cout << (const char*)qs << endl;
      if (file.at()>nextupdate)
	{
	  prog->setValue (file.at());
	  kapp->processEvents();
	  if (bcanceled==true)
	    {
	      delete m;
	      delete dialog;
	      return 0L;
	    }
	  nextupdate += file.size()/20;
	}
      
      //commas can be column separators
      for (unsigned int i=0;i<qs.length();i++)
	if (qs[i]==',')
	  qs[i]=' ';
      qs2=qs.simplifyWhiteSpace(); 
      qs=qs2;
      //      cout << qs << endl;
      g=f=0;
      ic=0;
      //Skip comment lines  (later: process commands)
      if (qs[0]=='#' || qs[0]=='%' || qs[0]=='\n')
	continue;
      while (ic<nc)
	{
	  double d;
	  
	  f=qs.find (' ', f);
	  if (f==-1 && ic!=ncm1)
	    {
	      delete dialog;
	      KMsgBox::message (this, "Matrix Format Error",
				"Cannot load matrix.  It is not in\n"
				" MxN (rectangular) format.",
				KMsgBox::STOP, "OK");
	      
	      delete m;
	      return 0L;
	    }
	  
	  if (f==-1)
	    f=qs.length();
	  d=atof (qs.mid (g,f-g));
	  if (nc==1)
	    {
	      m->set (ir, 0, cnt);
	      m->set (ir, 1, d);
	    }
	  else
	    m->set (ir, ic, d);
	  
	  cnt++;
	  ic++;
	  f++;
	  g=f;
	}
      ir++;
    }
  delete tmp;
  
  
  qs.sprintf ("Loaded %s", (const char*)filename);
  statusBar()->changeItem (qs, S_MAIN);
  
  delete dialog;
  return m;
}

void
KPSimple::slotCancel ()
{
  bcanceled=true;
  cancelwid->hide();
}

void
KPSimple::slotShow ()
{
  cancelwid->show();
}

void
KPSimple::slotOutput (KProcess *proc, char *buffer, int buflen)
{
  QString qs (buffer, buflen);
  printf ("KPLOT: [%s]\n", (const char *)qs);
}

int
KPSimple::findIndex (int index)
{
  index-=2;
  unsigned int i;
  for (i=0; i<matrices.count(); i++)
    if (matrices.at(i)->index == index)
	return (int)i;

  return -1;
}

void
KPSimple::slotHighlighted (int index)
{
  int i;
  if ( (i=findIndex (index))!=-1)
    statusBar()->message (matrices.at(i)->filename);
}

void
KPSimple::slotActivated (int index)
{
  int i;
  if ( (i=findIndex (index))!=-1)
    createFromFile (matrices.at(i)->filename, false);
}
