/**
 * QwPrinterSpriteFieldView
 * David Sweet <dsweet@chaos.umd.edu>
 * 
 * Derived from QwSpriteFieldView by Warwick Allison <warwick@troll.no>.
 * The field will be centered on the page an printed as large as possible
 *  while preserving the aspect ratio.
 **/


#ifndef QwPrinterSpriteFieldView_H
#define QwPrinterSpriteFieldView_H

#include <QwSpriteField.h>
#include <qprinter.h>
#include <qpicture.h>

class QwPrinterSpriteFieldView : public QPrinter, public QwAbsSpriteFieldView
{
public:
    QwPrinterSpriteFieldView(QwSpriteField* viewing=0);
    ~QwPrinterSpriteFieldView();

    void cleanPage ();
    void print ();
    void printAll (QwSpriteField* field=0);

    virtual QRect viewArea() const;
    virtual bool preferDoubleBuffering() const;
    virtual void beginPainter(QPainter&);
    virtual void flush ( const QRect & area );
protected:
    QPicture *pic;
    int w,h;

};


#endif
