/**
 * KPlotW
 *
 * A widget which has a KPView as its only child.
 **/


#ifndef __KPLOTW_H__
#define __KPLOTW_H__

#include <qwidget.h>
#include <qpopupmenu.h>

#include "kpswhatami.h"

class KPView;
class KPCoords;
class KPMatrix;
class KPS2D;
class KPColorTable;

class KPlotW : public QWidget
{
  Q_OBJECT

 public:
  
  enum PlotType {Parametric2D=RTTI_KPS2DParametric, 
		 Map2D=RTTI_KPS2DMap, Bars=RTTI_KPS2DBars};

  /**
   * Construct a KPlotW widget.
   **/
  KPlotW (QWidget *parent, char *name=0, WFlags flags=0);

  /**
   * Add a plot to the widget.  You can have as many as you want.
   * If _coords==0, then coordinates are chosen automatically.
   *
   * autoplus==TRUE attempts to find coordinates which include the
   *  rectangle described by the passed in coordinates and that
   *  described by the matrix.
   *
   * plottype is one of PlotType from kps2doptions.h
   **/
  KPS2D * addPlot (int plottype, KPMatrix *matrix,
		   KPCoords *coords=0,
		   KPColorTable *colortable=0);

  /**
   * Add a Right-Mouse-Button (context) menu to the page (on which
   *  lies the plot).
   **/
  void installRMBMenu (QPopupMenu *rmbmenu);

  /**
   * Access the KPView directly.
   **/
  KPView *view() { return kview; }

  public slots:

  /**
   * Print the view (see kpview.h for more)
   **/
  void slotPrint ();

  /**
   * Print a DRAFT of the view (see kpview.h for more)
   **/
  void slotPrintDraft ();


 protected:
  virtual void resizeEvent (QResizeEvent *);
  virtual void paintEvent ( QPaintEvent * );


 private:
  KPView *kview;

};

#endif
