#include <stdio.h> //for debugging
#include <iostream>

#include <qtimer.h>

#include "kps2d.moc"
#include "kpview.h"
#include "kporder.h"
#include "kpsaxis.h"
#include "kpscoordframe.h"

// A NOTE ABOUT COORDS AND RESIZING
// This widget alone determines the pixel-based x,y (in moveTo()) and 
//   w,h (in setRect()) in coords.  Other widgets (ex., axes) can
//   set the coordinate-based x,y,etc. if they signal for an update.
//
// This means that all of the KPS2D's (it's subclasses) on a single
//  page must be resizeEvent()'d  before any of the coord-dependent
//  sprites (like axes, text labels, etc.)


//This may be system-dependent
const int REDRAW_TIMEOUT = 0;

void
KPS2D::basicInit (const KPCoords &_coords, KPMatrix *_matrix)
{
  printf ("K2::basicInit\n");

  kcoords = _coords;
  bframe = true;
  kmatrix = _matrix;
  xaxis = 0;
  yaxis = 0;
  cframe = 0;
  buffer=0;
  paintbuffer=0;
  qtredraw = 0;
  bmiddleofredraw = false;
  bdoneredrawing = true;
  bneedredraw = true;

  setRect(); //brect needs to be something -- NECESSARY?
}

KPS2D::KPS2D (KPView *_view, const KPCoords &_coords,
			    KPMatrix *_matrix, 
			    double _x, double _y,
			    double _w, double _h, int _z) 
  : KPSprite (_view, _x, _y, _w, _h, _z)
{
  basicInit (_coords, _matrix);
}


KPS2D::KPS2D (KPView *_view, const KPCoords &_coords,
			    double _x, double _y,
			    double _w, double _h, int _z) 
  : KPSprite (_view, _x, _y, _w, _h, _z)
{
  basicInit (_coords, 0);
}

void
KPS2D::setMatrix (KPMatrix *_matrix)
{
  kmatrix = _matrix;
  bneedredraw = true;
}


void
KPS2D::setRect ()
{
  //The interaction of this and KPAxis can get a little tricky.  You need
  // this:
  //   KPSAxis::computeSizes() -- based only on view()
  //   KPS2D::setRect() -- based only on computeSizes() information
  //   KPSAxis::setRect() -- based on KCoords (which is updated here!)

  removeFromChunks();

  printf ("K2::setrect %f %f %f %f\n",
	  coords()->cxmin(),
	  coords()->cxmax(),
	  coords()->cymin(),
	  coords()->cymax());

  brect = QRect (//x(), y(),
		 lx*view()->width(),
		 ly*view()->height(),
		 lw*view()->width(),
		 lh*view()->height());

  printf ("K2::  %d %d %d %d\n",x(),y(),
	  brect.width(), brect.height());

  setARect();
  bneedredraw = true;

  //TEST
  setSelected(true);
  addToChunks();
}

void
KPS2D::setARect (void)
{
  //arect will depend on axes (computeSize()'s info), etc.
  int ax=x(), ay=y(), aw=brect.width(), ah=brect.height();

  if (xAxis())
    xAxis()->computeSizes();
  if (yAxis())
    yAxis()->computeSizes();
  if (coordFrame())
    coordFrame()->computeSizes();

  if (xAxis())
    {
      ah -= xAxis()->girth();

      ax += xAxis()->overSpill();
      aw -= xAxis()->overSpill()*2;

    }
  if (yAxis())
    {
      ax += yAxis()->girth();
      aw -= yAxis()->girth();

      ay += yAxis()->overSpill();
      ah -= yAxis()->overSpill()*2;
    }

  
  if(coordFrame())
    {
      ax += coordFrame()->girth().width();
      aw -= coordFrame()->girth().width()
	+ coordFrame()->overSpill().width();
      ay += coordFrame()->overSpill().height();
      ah -= coordFrame()->girth().height() + 
	coordFrame()->overSpill().height();
    }


  //  printf ("arect = %d %d %d %d\n",ax, ay, aw, ah);

  arect = QRect (ax, ay, aw, ah);

  coords()->setWidth (arect.width());
  coords()->setHeight (arect.height());

  coords()->setX0 (arect.x());
  coords()->setY0 (arect.y());
  printf ("ARECT : %d %d %d %d\n",
	  arect.x(), arect.y(), arect.width(), arect.height());
}

void
KPS2D::moveTo (int x, int y)
{
  KPSprite::moveTo(x,y);

  setARect();
  /*
  if (yAxis())
    yAxis()->moveBy (x-yAxis()->x(), y-yAxis()->y());
  if (xAxis())
    xAxis()->moveTo (x-xAxis()->x(), y-xAxis()->y());
  */

  

}


void
KPS2D::moveBy(int dx, int dy)
{
  KPSprite::moveBy(dx, dy);

  setARect();
}

QPainter *
KPS2D::beginRedraw (void)
{
  if (buffer)
    delete buffer;
  if (paintbuffer)
    delete paintbuffer;

  buffer = new QPixmap (brect.width(), brect.height());
  paintbuffer = new QPainter;

  return paintbuffer;
}

void
KPS2D::slotSnappyRedraw ()
{
  if (bdoneredrawing)
      return;

  paintbuffer->begin(buffer);
  if (bneedredraw)  //first time through
    {
      //Clear the pixmap background
      paintbuffer->fillRect (paintbuffer->window(), 
			     Qt::white);

    }
  paintbuffer->setWindow (brect);

  reDraw (paintbuffer);
  bneedredraw = false;
  paintbuffer->end();
  
  if (bdoneredrawing)
    {
      delete paintbuffer;
      paintbuffer=0;
      qtredraw->stop();
      delete qtredraw;
      qtredraw=0;
    }
  update();

  QTimer::singleShot (REDRAW_TIMEOUT, this, SLOT (slotSnappyRedraw()));
}

void
KPS2D::draw (QPainter &painter)
{
   if (postscript())
    {
      painter.setWindow (view()->rect());
      reDraw (&painter);
    }
    else
    {
      if (bneedredraw)
	{
	  beginRedraw();
	  
	  //Start timer
	  bdoneredrawing = false;
	  if (qtredraw)
	    {
	      qtredraw->stop();
	      delete qtredraw;
	      qtredraw=0;
	    }
	  
	  qtredraw = new QTimer;
	  ///      connect (qtredraw, SIGNAL (timeout()),
	  //       this, SLOT (slotSnappyRedraw()));
	  //      qtredraw->start (0);
	  QTimer::singleShot (0, this, SLOT (slotSnappyRedraw()));
	}
      else
	{
	  if (buffer)
	    {
	      painter.drawPixmap (brect.x(), brect.y(), *buffer);
	      //draw frame
	      if (bframe)
		{
                  if (!selected())
		    {
                      painter.setPen (DashLine);
                      painter.setRasterOp (NotROP);
		      painter.drawRect (brect);
		    }
		  else
		    {
		      painter.drawRect (brect);
		      QRect r (brect.x()+1, brect.y()+1,
				 brect.width()-2, brect.height()-2);
		      painter.drawRect (r);
		    }
		}
	    }
	}
    }

}


void
KPS2D::resizeEvent (QResizeEvent *r)
{

  bdoneredrawing=true;
  setRect(); //sets bneedredraw to true;
  KPSprite::resizeEvent (r); //does a moveTo

  //This shouldn't do all children.  KPSprite::resizeEvent()
  // shouldn't do all children, either, because KPView
  // sends everyone a resizeEvent.  The stuff below is special
  // (needed because of the interdependence between KPS2D and 
  //  the axes/coordframe).

  if (yAxis())
    yAxis()->resizeEvent (r);
  if (xAxis())
    xAxis()->resizeEvent (r);
  

  if (cframe)
    cframe->resizeEvent (r);
}


void
KPS2D::addXAxis (void)
{
  xaxis = new KPSAxis (view(), coords(), KPSAxis::X, ZAXIS);
  bneedredraw = true;
  addChild (xaxis);
  setRect();
  xaxis->setRect();
  if (yaxis)
    yaxis->setRect();
  view()->update();
}

void
KPS2D::addYAxis (void)
{
  yaxis = new KPSAxis (view(), coords(), KPSAxis::Y, ZAXIS);
  bneedredraw = true;
  addChild (yaxis);
  setRect();
  yaxis->setRect();
  if (xaxis)
    xaxis->setRect();
  update();
}

KPSCoordFrame *
KPS2D::addCoordFrame (void)
{
  cframe = new KPSCoordFrame (view(), coords(), ZAXIS);
  bneedredraw = true;
  addChild (cframe);
  setRect ();
  cframe->setRect();
  update();

  return cframe;
}

void
KPS2D::setCoords (const KPCoords &c, bool usedefaultticks)
{
  
  coords()->setCxmin (c.cxmin());
  coords()->setCymin (c.cymin());
  coords()->setCxmax (c.cxmax());
  coords()->setCymax (c.cymax());
  coords()->setCCrossx (c.ccrossx());
  coords()->setCCrossy (c.ccrossy());

  if (usedefaultticks)
    coords()->defaultTicks();
  else
    {
      coords()->setXTick (c.xTickSpacing());
      coords()->setYTick (c.yTickSpacing());
    }

  setRect();

  // updates() should be done outside
  //  update();

}

void KPS2D::removeChild (KPSprite *child)
{
  int ax=0;

  if (child==xaxis)
    {
      ax=1;
      xaxis=0;
    }
  else if (child==yaxis)
    {
      ax=2;
      yaxis=0;
    }
  else if (child==cframe)
    {
      ax=3;
      cframe=0;
    }


  if (ax!=0)
    {
      bneedredraw = true;
      setRect();
    }

  if (ax==1)
    {
      if (yaxis)
	yaxis->setRect();
    }
  else if (ax==2)
    {
      if (xaxis)
	xaxis->setRect();
    }

  KPSprite::removeChild (child);
}

KPCoords
KPS2D::autoCoords (const KPCoords *c)
{
  return KPCoords (0,0,0,0);
}
