#ifndef __KPS2DBARS_H__
#define __KPS2DBARS_H__

#include <qcolor.h>

#include "kps2d.h"

/**
 * KPS2DBars
 * Plot a bar graph.
 * @author David Sweet
 * 
 **/
class KPS2DBars : public KPS2D
{
  Q_OBJECT
  public:
  /**
   * Create a bar graph from matrix.  You might want to use
   *  @ref autoCoords() to get the coords.  The
   *  x, y, w, h, z are the position in the field on a scale of [0,1].
   **/
  KPS2DBars (KPView *view, KPCoords &coords, KPMatrix *matrix,
	     double x, double y, double w, double h, int z=0);
  
  
  /**
   * Find a good set of coordinates for this plot.
   **/
  virtual KPCoords autoCoords (const KPCoords *c = 0);

  /**
   * I am a KPS2DBars.
   **/
  virtual int whatami() const { return RTTI_KPS2DBars; }

 protected:
  virtual void reDraw (QPainter *);
  void computeSizes(void);
  virtual void resizeEvent (QResizeEvent *);                                    
 private:
  bool bdrawrims;
  QColor barcolor, rimcolor;
  double rimsize0;
  int rimsize;
};

#endif
