/***************************************************************************
                          gaussianplot.cpp  -  description
                             -------------------
    begin                : Tue Mar 28 2000
    copyright            : (C) 2000 by Gordon Machel
    email                : gmachel@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <klocale.h>

#include <math.h>

#include "gaussianplot.h"

// the number of data points of the fit curve
#define FITSIZE 128

/////////////////////////////////////////////////////////////////////////////
GaussianPlot::GaussianPlot(SetiLoc* loc, QWidget *parent, const char *name ) : SetiGraph(loc,true,true,parent,name)
{
// connect the SetiLoc signal to the new Gaussian slot of this widget.
location = loc;
connect(location, SIGNAL(newGaussian(SetiLoc*)), this, SLOT(showNewGaussianData(SetiLoc*)));

QString title;
title.sprintf(i18n("Top Gaussian for %s (right-click for options)"), (const char*)loc->location());
setCaption(title);
setBackgroundColor(black);
resize(350, 200);
setMinimumSize(150, 100);

// prepare data for display
showNewGaussianData(location);
}

/////////////////////////////////////////////////////////////////////////////
GaussianPlot::~GaussianPlot()
{
}

/////////////////////////////////////////////////////////////////////////////
void GaussianPlot::paintEvent(QPaintEvent* e)
{
QPainter p;

SetiGraph::paintEvent(e);
p.begin(this);
p.translate(0, rect().bottom());
drawCurve(fitData, SetiGraph::Lines, white, &p);
p.end();
}

/////////////////////////////////////////////////////////////////////////////
void GaussianPlot::calculateFitData()
{
double ratio = FITSIZE/64.0;
for(int i=0;i<FITSIZE;i++)
	{
	fitData[i] = top->gaussian_true_mean +
		top->gaussian_power*exp(-((i/ratio)-top->gaussian_fft_index)*((i/ratio)-top->gaussian_fft_index)/
		(top->gaussian_sigma*top->gaussian_sigma));
	}	
}

/////////////////////////////////////////////////////////////////////////////
void GaussianPlot::showNewGaussianData(SetiLoc* loc)
{
if(loc == location)
	{
	top = (WUScore*)location->topScore();
	setCurve((const double*)top->gaussian_data, 64);
	
  // generate the info text
  QString it;
  it.sprintf("power: %f\n"
             "mean  : %f\n"
             "sigma : %f\n"
             "fit       : %f\n"
             "score : %f",
             top->gaussian_power,
             top->gaussian_true_mean,
             top->gaussian_sigma,
             top->gaussian_chisq,
             top->gaussian
             );
  setInfoText(it);

  if(fitData.size() != FITSIZE) fitData.resize(FITSIZE);
	calculateFitData();
	repaint();
	}
}
